/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.process;

import com.almworks.jira.structure.api.process.ProcessButtonParameters;
import com.almworks.jira.structure.api.util.I18nText;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ProcessDisplayParameters {
    private I18nText myName;
    private List<ProcessButtonParameters> myButtons;

    public ProcessDisplayParameters() {
        this.myButtons = Lists.newArrayList();
    }

    public ProcessDisplayParameters(ProcessDisplayParameters parameters) {
        this.myName = parameters.myName;
        this.myButtons = Lists.newArrayList(parameters.myButtons);
    }

    public I18nText getName() {
        return this.myName;
    }

    public void setName(I18nText name) {
        this.myName = name;
    }

    public List<ProcessButtonParameters> getButtons() {
        return this.myButtons;
    }

    public void setButtons(List<ProcessButtonParameters> buttons) {
        this.myButtons = buttons;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ProcessDisplayParameters rhs = (ProcessDisplayParameters)obj;
        return new EqualsBuilder().append((Object)this.myName, (Object)rhs.myName).append(this.myButtons, rhs.myButtons).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.myName).append(this.myButtons).toHashCode();
    }

    public static class Builder {
        private final ProcessDisplayParameters myInstance;

        public Builder() {
            this.myInstance = new ProcessDisplayParameters();
        }

        public Builder(ProcessDisplayParameters instance) {
            this.myInstance = new ProcessDisplayParameters(instance);
        }

        public Builder withProcessName(String nameKey, Object ... args) {
            this.myInstance.myName = new I18nText(nameKey, args);
            return this;
        }

        public Builder addButton(String url, String captionKey, Object ... args) {
            this.myInstance.myButtons.add(new ProcessButtonParameters(new I18nText(captionKey, args), url));
            return this;
        }

        public ProcessDisplayParameters build() {
            return this.myInstance;
        }
    }
}

