/*
 * Decompiled with CFR 0.152.
 */
package io.tempo.anonymizer;

import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Component;

@Component
public class FileUtils {
    public File createPrefixed(File file, String prefix) {
        return new File(file.getAbsoluteFile().getParent() + "/" + prefix + file.getName());
    }

    public void rename(File file, String newName) {
        File renamedFile = new File(file.getAbsoluteFile().getParent() + "/" + newName);
        if (!file.renameTo(renamedFile)) {
            throw new RuntimeException(String.format("Failed to rename file %s to %s", file.getName(), newName));
        }
    }

    public void delete(File file) {
        if (file.exists()) {
            try {
                if (file.isDirectory()) {
                    org.apache.commons.io.FileUtils.deleteDirectory((File)file);
                } else {
                    org.apache.commons.io.FileUtils.delete((File)file);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

