/*
 * Decompiled with CFR 0.152.
 */
package io.tempo.anonymizer;

import io.tempo.anonymizer.ConfigurationService;
import io.tempo.anonymizer.model.ColumnRule;
import io.tempo.anonymizer.model.ColumnRuleType;
import io.tempo.anonymizer.model.CustomFieldType;
import io.tempo.anonymizer.model.TableAction;
import java.text.DecimalFormat;
import java.util.Random;
import org.jdom2.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AnonymizerMapper {
    private final double randomizer;

    @Autowired
    public AnonymizerMapper(Random random) {
        double min = 0.01;
        double max = 1000.0;
        this.randomizer = min + random.nextDouble() * (max - min);
    }

    private void doAnonymize(Element element, ColumnRule columnRule) {
        ColumnRuleType columnRuleType = columnRule.getColumnRuleType();
        String text = element.getText();
        if (columnRuleType.equals((Object)ColumnRuleType.TEXT)) {
            element.setText(this.replaceText(text));
        } else if (columnRuleType.equals((Object)ColumnRuleType.TEXT_UNIQUE)) {
            element.setText(this.replaceTextUnique(text));
        } else if (columnRuleType.equals((Object)ColumnRuleType.CURRENCY)) {
            element.setText(this.replaceCurrency(text, element, columnRule));
        }
    }

    public void doAnonymize(Element element, ColumnRule columnRule, CustomFieldType customFieldType) {
        this.validateElement(element, columnRule);
        String text = element.getText();
        if (this.isNotAnonymizable(element, text, columnRule)) {
            return;
        }
        ColumnRuleType columnRuleType = columnRule.getColumnRuleType();
        if (customFieldType == null || !columnRuleType.equals((Object)ColumnRuleType.CUSTOM_FIELD)) {
            this.doAnonymize(element, columnRule);
            return;
        }
        if (customFieldType.equals((Object)CustomFieldType.INPUT_FIELD)) {
            element.setText(this.replaceText(text));
        } else if (customFieldType.equals((Object)CustomFieldType.INPUT_NUMERIC)) {
            element.setText(this.replaceCurrency(text, element, columnRule));
        } else if (customFieldType.equals((Object)CustomFieldType.AMOUNT)) {
            element.setText(this.replaceCurrency(text, element, columnRule));
        } else if (customFieldType.equals((Object)CustomFieldType.TEXT)) {
            element.setText(this.replaceText(text));
        } else if (customFieldType.equals((Object)CustomFieldType.NUMBER)) {
            element.setText(this.replaceCurrency(text, element, columnRule));
        }
    }

    public void doAnonymize(Element data, TableAction action) {
        if (action.equals((Object)TableAction.CLEAN)) {
            data.removeChildren("row", ConfigurationService.NAMESPACE);
        }
    }

    private void validateElement(Element element, ColumnRule columnRule) {
        if (element == null) {
            throw new RuntimeException(String.format("Element is null for column rule %s", columnRule));
        }
        if (element.getText() == null) {
            throw new RuntimeException(String.format("Element %s has null text for column rule %s", element, columnRule));
        }
    }

    private boolean isNotAnonymizable(Element element, String text, ColumnRule columnRule) {
        return columnRule.getExclusions() != null && columnRule.getExclusions().stream().anyMatch(exclusion -> exclusion.equals(text)) || "DEFAULT".equals(text) || AnonymizerMapper.isXmlNull((Element)element);
    }

    private String replaceText(String text) {
        return text.replaceAll("([^ ])+?", "X");
    }

    private String replaceTextUnique(String text) {
        StringBuilder stringBuilder = new StringBuilder(text);
        Random random = new Random();
        for (int i = 0; i < text.length(); ++i) {
            if (stringBuilder.charAt(i) == ' ') continue;
            stringBuilder.setCharAt(i, (char)(random.nextInt(26) + 97));
        }
        return stringBuilder.toString();
    }

    private String replaceCurrency(String text, Element element, ColumnRule columnRule) {
        try {
            double value = Double.parseDouble(text);
            return new DecimalFormat("00.00").format(value * this.randomizer);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("Element %s is not applicable for rule %s", element, columnRule));
        }
    }

    private static boolean isXmlNull(Element element) {
        return element.getAttribute("nil", ConfigurationService.RESERVED_WORD_XML_NULL_NAMESPACE) != null && element.getAttribute("nil", ConfigurationService.RESERVED_WORD_XML_NULL_NAMESPACE).getValue().equals("true");
    }

    public double getRandomizer() {
        return this.randomizer;
    }
}

