package com.almworks.jira.structure.api.sync;

import com.almworks.jira.structure.api.util.La;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.google.common.collect.ImmutableMap;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

public class SyncEvents {
  public static final La<SyncEvent.Jira, Map<String, Object>> JIRA_EVENT_TO_MAP = new La<SyncEvent.Jira, Map<String,Object>>() {
    @Override
    public Map<String, Object> la(SyncEvent.Jira event) {
      if (event == null) return null;
      return buildSyncEventMap(event, 
        ImmutableMap.<String, Object>builder()
          .put("type", event.getEvent().getChangeType().toString())
          .put("issues", SyncAuditLogHelper.ISSUE_INFO.arrayList(event.getEvent().getAffectedIssuesSorted().toList()))
      );  
    }
  };
  
  public static final La<SyncEvent.Structure, Map<String, Object>> STRUCTURE_EVENT_TO_MAP = new La<SyncEvent.Structure, Map<String, Object>>() {
    @Override
    public Map<String, Object>la(SyncEvent.Structure event) {
      if (event == null) return null;
      return buildSyncEventMap(event, 
        ImmutableMap.<String, Object>builder()
          .put("version", event.getHistoryEntry().getVersion()));
    }
  };

  @NotNull
  private static Map<String, Object> buildSyncEventMap(@NotNull SyncEvent event, ImmutableMap.Builder<String, Object> builder) {
    builder.put("timestamp", event.getTimestamp());
    builder.put("syncInstanceId", StructureUtil.nnl(event.getSyncInstanceId()));
    return builder.build();
  }
}
