package com.almworks.jira.structure.api.export.printable;

import com.almworks.jira.structure.api.export.ExportCell;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.Nullable;

/**
 * {@code PrintableCell} is a specialization of {@link ExportCell} for exporting to the printable HTML format.
 *
 * @see PrintableColumn
 */
@PublicApi
public interface PrintableCell extends ExportCell {
  /**
   * Set an HTML fragment as the content of the current cell.
   *
   * @param html The HTML fragment. If {@code null}, the cell is cleared.
   */
  void setHtml(@Nullable String html);

  /**
   * Add CSS classes to the {@code class} attribute of the {@code &lt;td&gt;} element for the current cell. The CSS
   * rules for that class should be added to a CSS file in a web resource included into the {@code structure.printable}
   * context.
   *
   * @param classes The CSS classes.
   */
  void addClasses(String... classes);
}
