package com.almworks.jira.structure.api.cache.subtask;

import com.almworks.integers.LongCollector;
import com.almworks.integers.LongIterable;
import com.atlassian.annotations.Internal;

@Internal
public interface SubTaskIssueCache {
  /**
   * Collects sub-task issue IDs. Uses Lucene index and caching to speed up the checks.
   *
   * @param issues Issue IDs to check.
   * @param collector Collector to receive sub-task issue IDs. It's safe for the collector to modify
   * the {@code issues} collection, because the implementation copies it.
   */
  void collectSubTaskIssues(LongIterable issues, LongCollector collector);
}
