package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.integers.LongSet;
import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.*;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.row.StructureRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;
import java.util.function.BiFunction;

public class BaseSingleRowAttributeLoader<T> extends BaseAttributeLoader<T> implements SingleRowAttributeLoader<T> {
  @NotNull
  private final BiFunction<StructureRow, SingleRowAttributeContext, AttributeValue<T>> myLoadingFunction;

  @Nullable
  private final RowPreloadFunction myPreloadFunction;

  private final boolean myWholeForestDependent;

  public BaseSingleRowAttributeLoader(@NotNull AttributeSpec<T> attributeSpec,
    @Nullable Set<AttributeSpec<?>> dependencies,
    @Nullable Set<AttributeContextDependency> contextDependencies,
    @Nullable AttributeCachingStrategy cachingStrategy, @Nullable TrailItemSet globalTrail,
    @NotNull BiFunction<StructureRow, SingleRowAttributeContext, AttributeValue<T>> loadingFunction,
    @Nullable RowPreloadFunction preloadFunction, boolean wholeForestDependent)
  {
    super(attributeSpec, dependencies, contextDependencies, cachingStrategy, globalTrail);
    myLoadingFunction = loadingFunction;
    myPreloadFunction = preloadFunction;
    myWholeForestDependent = wholeForestDependent;
  }

  @Nullable
  @Override
  public AttributeValue<T> loadValue(@NotNull StructureRow row, @NotNull SingleRowAttributeContext context) {
    return myLoadingFunction.apply(row, context);
  }

  @Override
  public void preload(@NotNull LongSet rowIds, @NotNull ItemForest forest, @NotNull AttributeContext context) {
    if (myPreloadFunction != null) {
      myPreloadFunction.preload(rowIds, forest, context);
    }
  }

  @Override
  public boolean isWholeForestDependent() {
    return myWholeForestDependent;
  }
}
