package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.reduce.SingleDependencyReducingAggregateLoader;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class NumberSumLoader extends SingleDependencyReducingAggregateLoader<Number> {
  public NumberSumLoader(AttributeSpec<Number> spec, AttributeSpec<Number> dependency) {
    super(spec, dependency);
  }

  @Override
  public Number reduce(@NotNull List<Number> list) {
    NumberAccumulator total = new NumberAccumulator();
    list.stream().filter(Objects::nonNull).forEach(total::add);
    return total.toNumber();
  }

  // optimization
  @Override
  public Number merge(@NotNull Supplier<Number> self, @NotNull Supplier<Number> reduced) {
    NumberAccumulator total = new NumberAccumulator();
    total.add(self.get());
    total.add(reduced.get());
    return total.toNumber();
  }

  // optimization
  @Override
  public Number merge(Supplier<Number> self, List<Number> list) {
    NumberAccumulator total = new NumberAccumulator();
    total.add(self.get());
    list.stream().filter(Objects::nonNull).forEach(total::add);
    return total.toNumber();
  }
}
