/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.atlassian.annotations.PublicApi;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

@PublicApi
public final class NumericFunctions {
    public static long longOrZero(Number number) {
        return number == null ? 0L : number.longValue();
    }

    public static <T> long longOrZero(T argument, Function<? super T, ? extends Number> function) {
        if (argument == null || function == null) {
            return 0L;
        }
        return NumericFunctions.longOrZero(function.apply(argument));
    }

    @Nullable
    public static Long longOrNull(Number number) {
        return number == null ? null : (number instanceof Long ? (Long)number : Long.valueOf(number.longValue()));
    }

    @Nullable
    public static <T> Long longOrNull(T argument, Function<? super T, ? extends Number> function) {
        if (argument == null || function == null) {
            return null;
        }
        return NumericFunctions.longOrNull(function.apply(argument));
    }

    public static long nonNegativeLong(Number number) {
        return Math.max(0L, NumericFunctions.longOrZero(number));
    }

    public static <T> long nonNegativeLong(T argument, Function<? super T, ? extends Number> function) {
        return Math.max(0L, NumericFunctions.longOrZero(argument, function));
    }

    public static double doubleOrZero(Number number) {
        return number == null ? 0.0 : number.doubleValue();
    }

    public static <T> double doubleOrZero(T argument, Function<? super T, ? extends Number> function) {
        if (argument == null || function == null) {
            return 0.0;
        }
        return NumericFunctions.doubleOrZero(function.apply(argument));
    }

    @Nullable
    public static Double doubleOrNull(Number number) {
        return number == null ? null : (number instanceof Double ? (Double)number : Double.valueOf(number.doubleValue()));
    }

    @Nullable
    public static <T> Double doubleOrNull(T argument, Function<? super T, ? extends Number> function) {
        if (argument == null || function == null) {
            return null;
        }
        return NumericFunctions.doubleOrNull(function.apply(argument));
    }

    public static double nonNegativeDouble(Number number) {
        return Math.max(0.0, NumericFunctions.doubleOrZero(number));
    }

    public static <T> double nonNegativeDouble(T argument, Function<? super T, ? extends Number> function) {
        return Math.max(0.0, NumericFunctions.doubleOrZero(argument, function));
    }

    public static Double nonNegativeDoubleAddOrNull(Number a, Number b) {
        if (a == null && b == null) {
            return null;
        }
        return NumericFunctions.nonNegativeDouble(a) + NumericFunctions.nonNegativeDouble(b);
    }

    public static Long longAddOrNull(Number a, Number b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b.longValue();
        }
        if (b == null) {
            return a.longValue();
        }
        return a.longValue() + b.longValue();
    }

    public static long longAddOrNull(long a, Long b) {
        if (b == null) {
            return a;
        }
        return a + b;
    }

    public static boolean equals(Number a, Number b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

