/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.integers.IntArray;
import com.almworks.integers.IntCollections;
import com.almworks.integers.IntFindingIterator;
import com.almworks.integers.IntIterator;
import com.almworks.integers.LongArray;
import com.almworks.integers.LongFindingIterator;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongList;
import com.almworks.integers.WritableIntList;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.util.StructureUtil;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedForest {
    private final Forest myForest;
    private final Supplier<WritableIntList> mySubtreeEnds;
    private final Supplier<WritableIntList> myParents;
    @Nullable
    private WritableIntList mySubtreeStarts;
    @Nullable
    private List<WritableIntList> mySiblingBuffers;

    public IndexedForest(Forest forest) {
        this.myForest = forest;
        int size = forest.size();
        this.mySubtreeEnds = IndexedForest.createForestIndex(size);
        this.myParents = IndexedForest.createForestIndex(size);
    }

    private static Supplier<WritableIntList> createForestIndex(int size) {
        return StructureUtil.memoize(() -> new IntArray(IntCollections.repeat((int)-1, (int)size)));
    }

    public int subtreeEnd(int idx) {
        if (idx < 0) {
            return this.size();
        }
        WritableIntList subtreeEnds = this.mySubtreeEnds.get();
        int end = subtreeEnds.get(idx);
        if (end < 0) {
            end = this.calcSubtreeEnds(idx, subtreeEnds);
        }
        assert (end >= 0);
        return end;
    }

    private int calcSubtreeEnds(int i, WritableIntList subtreeEnds) {
        WritableIntList subtreeStarts = this.prepareSubtreeStarts();
        int n = this.myForest.size();
        int startDepth = this.myForest.getDepth(i);
        ++i;
        while (i < n + 1) {
            int lastDepth;
            int depth = i < n ? Math.max(this.myForest.getDepth(i) - startDepth, 0) : 0;
            if (depth > (lastDepth = subtreeStarts.size())) {
                subtreeStarts.add(i - 1);
            } else if (depth == lastDepth) {
                subtreeEnds.set(i - 1, i);
            } else {
                for (int j = lastDepth - 1; j >= depth; --j) {
                    subtreeEnds.set(subtreeStarts.get(j), i);
                }
                subtreeStarts.removeRange(depth, lastDepth);
            }
            if (depth == 0) {
                assert (subtreeStarts.isEmpty());
                return i;
            }
            ++i;
        }
        assert (false);
        return i + 1;
    }

    @NotNull
    private WritableIntList prepareSubtreeStarts() {
        WritableIntList subtreeStarts = this.mySubtreeStarts;
        if (subtreeStarts == null) {
            this.mySubtreeStarts = subtreeStarts = new IntArray();
        } else {
            subtreeStarts.clear();
        }
        return subtreeStarts;
    }

    public int parent(int idx) {
        if (idx < 0) {
            return -1;
        }
        WritableIntList parents = this.myParents.get();
        if (this.myForest.getDepth(idx) == 0) {
            return -1;
        }
        int parent = parents.get(idx);
        if (parent < 0) {
            parent = this.calcParent(idx, parents);
        }
        assert (parent >= 0);
        return parent;
    }

    private int calcParent(int idx, WritableIntList parents) {
        List<WritableIntList> siblingBuffers = this.prepareSiblingBuffers();
        int i = idx;
        int targetDepth = this.myForest.getDepth(idx);
        int lastRelDepth = -1;
        while (true) {
            int relDepth;
            if ((relDepth = this.myForest.getDepth(i) - targetDepth) < lastRelDepth) {
                assert (relDepth + 1 == lastRelDepth);
                for (IntIterator siblingIdx : siblingBuffers.get(lastRelDepth)) {
                    parents.set(siblingIdx.value(), i);
                }
            }
            if (relDepth < 0) break;
            for (int j = lastRelDepth + 1; j <= relDepth; ++j) {
                if (j == siblingBuffers.size()) {
                    siblingBuffers.add((WritableIntList)new IntArray());
                }
                siblingBuffers.get(j).clear();
            }
            siblingBuffers.get(relDepth).add(i);
            lastRelDepth = relDepth;
            int parent = parents.get(i);
            if (parent >= 0) {
                i = parent;
                continue;
            }
            --i;
        }
        return parents.get(idx);
    }

    @NotNull
    private List<WritableIntList> prepareSiblingBuffers() {
        List<WritableIntList> siblingBuffers = this.mySiblingBuffers;
        if (siblingBuffers == null) {
            this.mySiblingBuffers = siblingBuffers = new ArrayList<WritableIntList>(4);
        }
        return siblingBuffers;
    }

    @NotNull
    public IntIterator children(int idx) {
        final int first = this.firstChild(idx);
        if (first < 0) {
            return IntIterator.EMPTY;
        }
        return new IntFindingIterator(){
            private int myPending;
            {
                this.myPending = first;
            }

            protected boolean findNext() throws ConcurrentModificationException {
                if (this.myPending < 0) {
                    return false;
                }
                this.myNext = this.myPending;
                this.myPending = IndexedForest.this.nextSibling(this.myPending);
                return true;
            }
        };
    }

    @NotNull
    public IntIterator roots() {
        return this.children(-1);
    }

    public LongList childrenRows(int idx) {
        IntIterator children = this.children(idx);
        if (!children.hasNext()) {
            return LongList.EMPTY;
        }
        return new LongArray(this.rows(children));
    }

    public int firstChild(int idx) {
        int size = this.size();
        if (idx == -1) {
            return size > 0 ? 0 : -1;
        }
        if (idx < 0 || idx >= size) {
            return -1;
        }
        int k = idx + 1;
        return k < size && this.depth(k) == this.depth(idx) + 1 ? k : -1;
    }

    public int nextSibling(int idx) {
        int size = this.size();
        if (idx < 0 || idx >= size) {
            return -1;
        }
        int k = this.subtreeEnd(idx);
        return k < size && this.depth(k) == this.depth(idx) ? k : -1;
    }

    public int depth(int idx) {
        return this.myForest.getDepth(idx);
    }

    public long row(int idx) {
        return this.myForest.getRow(idx);
    }

    public LongIterator rows(final IntIterator indices) {
        return new LongFindingIterator(){

            protected boolean findNext() {
                if (indices.hasNext()) {
                    this.myNext = IndexedForest.this.row(indices.nextValue());
                    return true;
                }
                return false;
            }
        };
    }

    public int size() {
        return this.myForest.size();
    }

    public Forest getForest() {
        return this.myForest;
    }

    public int root(int idx) {
        while (idx >= 0 && this.depth(idx) > 0) {
            idx = this.parent(idx);
        }
        return idx;
    }
}

