/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.atlassian.annotations.Internal;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.TypeReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class JsonUtil {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtil.class);
    public static final TypeReference<Map<String, Object>> JSON_MAP = new TypeReference<Map<String, Object>>(){};

    @NotNull
    public static String toJson(@Nullable Object object) {
        return JsonUtil.toJson(object, JsonUtil.defaultMapper());
    }

    @NotNull
    public static String toJson(@Nullable Object object, ObjectMapper mapper) {
        if (object == null) {
            return "";
        }
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.warn("failed to serialize " + object, (Throwable)e);
            return "";
        }
    }

    @Nullable
    public static <T> T fromJson(String specJson, Class<T> expectedClass) {
        return JsonUtil.fromJson(specJson, expectedClass, JsonUtil.defaultMapper());
    }

    @Nullable
    public static <T> T fromJson(String specJson, Class<T> expectedClass, ObjectMapper mapper) {
        if (specJson == null || specJson.length() == 0) {
            return null;
        }
        try {
            return (T)mapper.readValue(specJson, expectedClass);
        }
        catch (IOException e) {
            logger.warn("failed to deserialize " + specJson + " for " + expectedClass, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static <T> T fromJson(String json, TypeReference<T> typeRef) {
        return JsonUtil.fromJson(json, typeRef, JsonUtil.defaultMapper());
    }

    @Nullable
    public static <T> T fromJson(String json, TypeReference<T> typeRef, ObjectMapper mapper) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, typeRef);
        }
        catch (IOException e) {
            logger.warn("failed to deserialize " + json + " for " + typeRef, (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> fromJson(String json) {
        return JsonUtil.fromJson(json, JsonUtil.defaultMapper());
    }

    @Nullable
    public static Map<String, Object> fromJson(String json, ObjectMapper mapper) {
        return JsonUtil.fromJson(json, JSON_MAP, mapper);
    }

    @Nullable
    public static <T> T fromMap(Map json, Class<T> expectedClass) {
        return JsonUtil.fromMap(json, expectedClass, JsonUtil.defaultMapper());
    }

    @Nullable
    public static <T> T fromMap(Map json, Class<T> expectedClass, ObjectMapper mapper) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            return (T)mapper.convertValue((Object)json, expectedClass);
        }
        catch (IllegalArgumentException e) {
            logger.warn("failed to convert " + json + " to " + expectedClass, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Map<String, Object> toMap(Object object) {
        return JsonUtil.toMap(object, JsonUtil.defaultMapper());
    }

    @Nullable
    public static Map<String, Object> toMap(Object object, ObjectMapper mapper) {
        try {
            return (Map)mapper.convertValue(object, JSON_MAP);
        }
        catch (IllegalArgumentException e) {
            logger.warn("failed to convert " + object + " to " + JSON_MAP, (Throwable)e);
            return null;
        }
    }

    public static ObjectMapper defaultMapper() {
        return new ObjectMapper().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    public static ObjectMapper withUnknownPropertiesMapper() {
        return JsonUtil.defaultMapper().disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    @NotNull
    public static String encodeInlineJson(@NotNull String json) {
        return json.replace("/", "\\/");
    }
}

