/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.sync;

import com.almworks.integers.LongList;
import com.almworks.jira.structure.api.event.JiraChangeEvent;
import com.almworks.jira.structure.api.structure.history.HistoryEntry;
import com.atlassian.annotations.PublicApi;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jetbrains.annotations.Nullable;

@PublicApi
public abstract class SyncEvent
implements Comparable<SyncEvent> {
    static final ThreadLocal<DateFormat> TIMESTAMP_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss.SSS'Z'");
            fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            return fmt;
        }
    };
    private final long myTimestamp;
    private final Long mySyncInstanceId;

    private SyncEvent(long timestamp, @Nullable Long syncInstanceId) {
        this.myTimestamp = timestamp;
        this.mySyncInstanceId = syncInstanceId;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Nullable
    public Long getSyncInstanceId() {
        return this.mySyncInstanceId;
    }

    @Override
    public int compareTo(SyncEvent o) {
        return Long.compare(this.myTimestamp, o.myTimestamp);
    }

    protected StringBuilder toString(StringBuilder builder) {
        if (this.mySyncInstanceId != null) {
            builder.append(':').append(this.mySyncInstanceId);
        }
        builder.append(TIMESTAMP_FORMAT.get().format(new Date(this.myTimestamp)));
        return builder;
    }

    @PublicApi
    public static final class Jira
    extends SyncEvent {
        private final JiraChangeEvent myEvent;

        public Jira(long timestamp, Long syncInstanceId, JiraChangeEvent event) {
            super(timestamp, syncInstanceId);
            if (event == null) {
                throw new NullPointerException();
            }
            this.myEvent = event;
        }

        public JiraChangeEvent getEvent() {
            return this.myEvent;
        }

        public LongList getAffectedIssuesSorted() {
            return this.myEvent.getAffectedIssuesSorted();
        }

        public String toString() {
            return this.toString(new StringBuilder("j(")).append(',').append(this.myEvent).append(')').toString();
        }
    }

    @PublicApi
    public static final class Structure
    extends SyncEvent {
        private final HistoryEntry myHistoryEntry;

        public Structure(HistoryEntry historyEntry) {
            super(historyEntry.getTimestamp(), historyEntry.getSynchronizer());
            this.myHistoryEntry = historyEntry;
        }

        public HistoryEntry getHistoryEntry() {
            return this.myHistoryEntry;
        }

        public String toString() {
            return this.toString(new StringBuilder("s(")).append(',').append(this.myHistoryEntry).append(')').toString();
        }
    }
}

