package com.almworks.jira.structure.api.util;

import org.slf4j.Logger;

public final class LoggingUtils {
  private LoggingUtils() {}

  public static void warnExceptionIfDebug(Logger log, String message, Throwable t) {
    if (log.isDebugEnabled()) {
      log.warn(message, t);
    } else if (t != null) {
      log.warn(message + " " + getMessageWithCauseChain(t));
    } else {
      log.warn(message);
    }
  }

  public static String getMessageWithCauseChain(Throwable t) {
    StringBuilder sb = new StringBuilder();
    String pre = "";
    while (t != null) {
      sb.append(pre).append(t);
      t = t.getCause();
      pre = "; ";
    }
    return sb.toString();
  }
}
