package com.almworks.jira.structure.api.sync;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Locale;


public enum SourceOfTruth {
  JIRA("jira"),
  STRUCTURE("structure");
  
  private final String myCode;

  SourceOfTruth(String code) {
    myCode = code;
  }

  @NotNull
  public static SourceOfTruth fromCode(@Nullable String code) {
    SourceOfTruth value = parse(code);
    if (value == null) throw new IllegalArgumentException("Unknown code for SourceOfTruth " + code);
    return value;
  }

  @Nullable
  private static SourceOfTruth parse(@Nullable String code) {
    if (code == null) return null;
    switch (code.toLowerCase(Locale.ENGLISH)) {
    case "jira": return JIRA;
    case "structure": return STRUCTURE;
    default: return null;
    }
  }

  public String getCode() {
    return myCode;
  }
}
