/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.sync;

import com.almworks.jira.structure.api.StructureComponents;
import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.error.StructureRuntimeException;
import com.almworks.jira.structure.api.forest.ForestSource;
import com.almworks.jira.structure.api.item.CoreIdentities;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.permissions.PermissionLevel;
import com.almworks.jira.structure.api.row.MissingRowException;
import com.almworks.jira.structure.api.row.RowManager;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.structure.StructureManager;
import com.almworks.jira.structure.api.sync.IncrementalSyncData;
import com.almworks.jira.structure.api.sync.StructureSynchronizer;
import com.almworks.jira.structure.api.sync.SyncAuditLog;
import com.almworks.jira.structure.api.sync.SyncAuditLogHelper;
import com.almworks.jira.structure.api.sync.SyncInstance;
import com.almworks.jira.structure.api.sync.SynchronizerDescriptor;
import com.almworks.jira.structure.api.sync.util.SyncLogger;
import com.almworks.jira.structure.api.util.JiraComponents;
import com.almworks.jira.structure.api.util.MapObject;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicSpi
public abstract class AbstractSynchronizer
implements StructureSynchronizer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSynchronizer.class);
    private final ObjectMapper myObjectMapper = new ObjectMapper();
    protected final StructureComponents myStructureComponents;
    protected final StructureManager myStructureManager;
    protected final RowManager myRowManager;
    protected final SyncAuditLog myAuditLog;
    private volatile IssueManager myIssueManager;
    private volatile SynchronizerDescriptor myDescriptor;

    protected AbstractSynchronizer(StructureComponents structureComponents) {
        this.myStructureComponents = structureComponents;
        this.myAuditLog = structureComponents.getSyncAuditLog();
        this.myStructureManager = structureComponents.getStructureManager();
        this.myRowManager = structureComponents.getRowManager();
    }

    public void init(SynchronizerDescriptor descriptor) {
        this.myDescriptor = descriptor;
    }

    @Override
    @NotNull
    public SynchronizerDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @NotNull
    protected String getText(@NotNull String key, Object ... parameters) {
        return this.getDescriptor().getI18nBean().getText(key, (Object)parameters);
    }

    @Override
    public void addDefaultFormParameters(@NotNull Map<String, Object> params) {
    }

    @Override
    public String storeParameters(Object parameters) throws IOException {
        if (parameters == null) {
            return null;
        }
        if (!(parameters instanceof Map)) {
            throw new IOException("Wrong parameters object type: " + parameters + " (" + parameters.getClass().getName() + "), expected: Map");
        }
        return this.myObjectMapper.writeValueAsString(parameters);
    }

    @Override
    public Map<String, Object> restoreParameters(String data) throws IOException {
        if (data == null) {
            return null;
        }
        return (Map)this.myObjectMapper.readValue(data, StructureUtil.mapType());
    }

    protected Map<String, Object> castParameters(Object p) {
        if (p == null) {
            return null;
        }
        if (!(p instanceof Map)) {
            logger.warn(this + ": params of class " + p.getClass().getName() + " are not acceptable, expected: Map");
            return null;
        }
        return StructureUtil.mapType().cast(p);
    }

    protected MapObject parametersAsMapObject(Object p) {
        Map<String, Object> map = this.castParameters(p);
        return map == null ? null : new MapObject(map);
    }

    @NotNull
    protected MapObject parametersAsNNMapObject(Object p) {
        MapObject mapObject = this.parametersAsMapObject(p);
        return mapObject != null ? mapObject : MapObject.EMPTY;
    }

    protected boolean verifyStructureEditPermissions(long structureId) {
        return this.verifyStructureEditPermissions(structureId, SyncLogger.get());
    }

    protected boolean verifyStructureEditPermissions(long structureId, SyncLogger log) {
        boolean r = this.myStructureManager.isAccessible(structureId, PermissionLevel.EDIT);
        if (!r) {
            log.warn("cannot run under user", StructureUtil.username(this.getCurrentUser()), "because he or she does not have permissions to edit the structure");
        }
        return r;
    }

    private ApplicationUser getCurrentUser() {
        return StructureAuth.getUser();
    }

    @Nullable
    protected Issue getIssue(long issueId) {
        MutableIssue issueObject = null;
        try {
            issueObject = this.getIssueManager().getIssueObject(Long.valueOf(issueId));
        }
        catch (Exception e) {
            logger.warn("cannot retrieve issue " + issueId + ": " + e);
        }
        return issueObject;
    }

    @Nullable
    protected Issue getIssue(@NotNull String key) {
        MutableIssue issueObject = null;
        try {
            issueObject = this.getIssueManager().getIssueObject(key);
        }
        catch (Exception e) {
            logger.warn("cannot retrieve issue " + key + ": " + e);
        }
        return issueObject;
    }

    @NotNull
    protected IssueManager getIssueManager() {
        IssueManager issueManager = this.myIssueManager;
        if (issueManager == null) {
            this.myIssueManager = issueManager = JiraComponents.getIssueManager();
            if (issueManager == null) {
                throw new StructureRuntimeException("IssueManager is not available");
            }
        }
        return issueManager;
    }

    @Nullable
    protected Issue getIssueByRowId(long rowId) {
        long issueId = this.getIssueIdByRowId(rowId);
        return issueId == 0L ? null : this.getIssue(issueId);
    }

    protected final long getIssueIdByRowId(long rowId) {
        try {
            return AbstractSynchronizer.getIssueIdByRow(this.myRowManager.getRow(rowId));
        }
        catch (MissingRowException e) {
            SyncLogger.get().warnException(e, new Object[0]);
            return 0L;
        }
    }

    public static long getIssueIdByRow(StructureRow structureRow) {
        ItemIdentity itemId = structureRow.getItemId();
        if (CoreIdentities.isIssue(itemId)) {
            return itemId.getLongId();
        }
        return 0L;
    }

    @Override
    public void sync(@NotNull SyncInstance instance, @NotNull IncrementalSyncData syncData, @NotNull ForestSource forestSource) throws StructureException {
        SyncRunAuditEntry result = this.doSync(instance, syncData, forestSource);
        List<MapObject> actions = result.getActions();
        if (this.myAuditLog.isActionGroupRecorded(actions)) {
            MapObject auditEntryDesc = SyncAuditLogHelper.createAuditLogEntryDescription(instance, syncData, result.getDescription());
            this.myAuditLog.recordActions(instance, auditEntryDesc, actions);
        }
    }

    @Override
    public void resync(@NotNull SyncInstance instance, @NotNull ForestSource forestSource) throws StructureException {
        SyncRunAuditEntry result = this.doResync(instance, forestSource);
        List<MapObject> actions = result.getActions();
        if (this.myAuditLog.isActionGroupRecorded(actions)) {
            MapObject auditEntryDesc = SyncAuditLogHelper.createAuditLogEntryDescription(instance, null, result.getDescription());
            this.myAuditLog.recordActions(instance, auditEntryDesc, actions);
        }
    }

    @NotNull
    protected abstract SyncRunAuditEntry doSync(@NotNull SyncInstance var1, @NotNull IncrementalSyncData var2, @NotNull ForestSource var3) throws StructureException;

    @NotNull
    protected abstract SyncRunAuditEntry doResync(@NotNull SyncInstance var1, @NotNull ForestSource var2) throws StructureException;

    protected static SyncRunAuditEntry success(List<MapObject> actions) {
        return new SyncRunAuditEntry.Success(actions);
    }

    protected static SyncRunAuditEntry failure(String reason) {
        return new SyncRunAuditEntry.Failure(null, reason);
    }

    protected static SyncRunAuditEntry failure(Throwable throwable) {
        return new SyncRunAuditEntry.Failure(throwable, null);
    }

    protected static SyncRunAuditEntry failure(Throwable throwable, String reason) {
        return new SyncRunAuditEntry.Failure(throwable, reason);
    }

    protected static interface SyncRunAuditEntry {
        public List<MapObject> getActions();

        public Map<String, Object> getDescription();

        public static class Failure
        implements SyncRunAuditEntry {
            private final Throwable myThrowable;
            private final String myReason;

            public Failure(Throwable throwable, String reason) {
                this.myThrowable = throwable;
                this.myReason = reason;
            }

            @Override
            public List<MapObject> getActions() {
                return Collections.emptyList();
            }

            @Override
            public Map<String, Object> getDescription() {
                return SyncAuditLogHelper.getFailureDescription(this.myReason, this.myThrowable);
            }
        }

        public static class Success
        implements SyncRunAuditEntry {
            private final List<MapObject> myActions;
            private static final Map<String, Object> DESCRIPTION = ImmutableMap.of((Object)"result", (Object)"success");

            public Success(List<MapObject> actions) {
                this.myActions = actions;
            }

            @Override
            public List<MapObject> getActions() {
                return this.myActions;
            }

            @Override
            public Map<String, Object> getDescription() {
                return DESCRIPTION;
            }
        }
    }
}

