/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.item.generic;

import com.almworks.jira.structure.api.util.JsonMapUtil;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.PublicApi;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public final class GenericItem {
    @NotNull
    private final String myName;
    @Nullable
    private final Long myOwningStructure;
    @Nullable
    private final String myDescription;
    @NotNull
    private final Map<String, Object> myParameters;

    @NotNull
    public static Builder named(@NotNull String name) {
        return new Builder(name);
    }

    @NotNull
    public static Builder copy(@NotNull GenericItem genericItem) {
        return new Builder(genericItem.getName()).setOwningStructure(genericItem.getOwningStructure()).setDescription(genericItem.getDescription()).setParameters(genericItem.getParameters());
    }

    private GenericItem(@NotNull String name, @Nullable Long owningStructure, @Nullable String description, @Nullable Map<String, Object> parameters) {
        this.myName = StructureUtil.nonBlank(name);
        this.myOwningStructure = owningStructure;
        this.myDescription = description;
        this.myParameters = JsonMapUtil.copyParameters(parameters, false, true, false);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public Long getOwningStructure() {
        return this.myOwningStructure;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public Map<String, Object> getParameters() {
        return this.myParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericItem that = (GenericItem)o;
        return this.myName.equals(that.myName) && Objects.equals(this.myOwningStructure, that.myOwningStructure) && Objects.equals(this.myDescription, that.myDescription) && this.myParameters.equals(that.myParameters);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myOwningStructure, this.myDescription, this.myParameters);
    }

    public String toString() {
        return "GenericItem{myName='" + this.myName + '\'' + ", myOwningStructure=" + this.myOwningStructure + ", myDescription='" + this.myDescription + '\'' + ", myParameters=" + this.myParameters + '}';
    }

    @PublicApi
    public static final class Builder {
        @NotNull
        private String myName;
        @Nullable
        private Long myOwningStructure;
        @Nullable
        private String myDescription;
        @Nullable
        private Map<String, Object> myParameters;

        private Builder(@NotNull String name) {
            this.myName = this.checkName(name);
        }

        @NotNull
        public Builder setName(@NotNull String name) {
            this.myName = this.checkName(name);
            return this;
        }

        private String checkName(String name) {
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException("name cannot be empty");
            }
            return StringUtils.abbreviate((String)name, (int)190);
        }

        @NotNull
        public Builder setOwningStructure(@Nullable Long owningStructure) {
            this.myOwningStructure = owningStructure;
            return this;
        }

        @NotNull
        public Builder setDescription(@Nullable String description) {
            this.myDescription = description;
            return this;
        }

        @NotNull
        public Builder setParameter(@NotNull String name, @Nullable Object value) {
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException("parameter name cannot be empty");
            }
            if (value == null) {
                if (this.myParameters != null) {
                    this.myParameters.remove(name);
                }
            } else {
                if (this.myParameters == null) {
                    this.myParameters = new LinkedHashMap<String, Object>();
                }
                this.myParameters.put(name, value);
            }
            return this;
        }

        @NotNull
        public Builder setParameters(@Nullable Map<String, Object> params) {
            this.myParameters = params != null ? new LinkedHashMap<String, Object>(params) : null;
            return this;
        }

        @NotNull
        public GenericItem build() {
            return new GenericItem(this.myName, this.myOwningStructure, this.myDescription, this.myParameters);
        }
    }
}

