/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.item;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongList;
import com.almworks.integers.LongOpenHashSet;
import com.almworks.integers.LongSizedIterable;
import com.almworks.integers.WritableLongSet;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.ItemAccessMode;
import com.almworks.jira.structure.api.row.RowRetriever;
import com.atlassian.annotations.Internal;
import com.google.common.collect.AbstractIterator;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class ItemIdentitySet
extends AbstractSet<ItemIdentity> {
    private static final int SUBSET_INITIAL_CAPACITY = 10;
    @Nullable
    private Map<String, COWLongSet> myLongIds;
    @Nullable
    private Map<String, COWStringSet> myStringIds;
    private int myModCount;
    private volatile boolean myImmutable;

    public ItemIdentitySet() {
    }

    public ItemIdentitySet(ItemIdentity ... ids) {
        if (ids != null) {
            this.addAll((Collection<? extends ItemIdentity>)Arrays.asList(ids));
        }
    }

    public ItemIdentitySet(Collection<? extends ItemIdentity> ids) {
        if (ids != null) {
            this.addAll(ids);
        }
    }

    public static ItemIdentitySet of(String itemType, long[] ids) {
        return ItemIdentitySet.of(itemType, (LongIterable)new LongArray(ids));
    }

    public static ItemIdentitySet of(String itemType, LongIterable ids) {
        ItemIdentitySet set = new ItemIdentitySet();
        set.addAll(itemType, ids);
        return set;
    }

    public static ItemIdentitySet of(String itemType, Iterable<String> ids) {
        ItemIdentitySet set = new ItemIdentitySet();
        set.addAll(itemType, ids);
        return set;
    }

    @Override
    @NotNull
    public Iterator<ItemIdentity> iterator() {
        return new RecollectingIterator();
    }

    @Override
    public int size() {
        int r = 0;
        if (this.myLongIds != null) {
            for (COWLongSet cOWLongSet : this.myLongIds.values()) {
                r += ((WritableLongSet)cOWLongSet.set()).size();
            }
        }
        if (this.myStringIds != null) {
            for (COWStringSet cOWStringSet : this.myStringIds.values()) {
                r += ((Set)cOWStringSet.set()).size();
            }
        }
        return r;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof ItemIdentity)) {
            return false;
        }
        ItemIdentity id = (ItemIdentity)o;
        if (id.isLongId()) {
            if (this.myLongIds == null) {
                return false;
            }
            COWLongSet set = this.myLongIds.get(id.getItemType());
            return set != null && ((WritableLongSet)set.set()).contains(id.getLongId());
        }
        if (this.myStringIds == null) {
            return false;
        }
        COWStringSet set = this.myStringIds.get(id.getItemType());
        return set != null && ((Set)set.set()).contains(id.getStringId());
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c.size() > this.size()) {
            return false;
        }
        if (!(c instanceof ItemIdentitySet)) {
            return super.containsAll(c);
        }
        ItemIdentitySet set = (ItemIdentitySet)c;
        if (set.myLongIds != null) {
            for (Map.Entry<String, COWBaseSet> entry : set.myLongIds.entrySet()) {
                if (((WritableLongSet)((COWLongSet)entry.getValue()).set()).isEmpty()) continue;
                if (this.myLongIds == null) {
                    return false;
                }
                COWLongSet longSet = this.myLongIds.get(entry.getKey());
                if (longSet != null && ((WritableLongSet)longSet.set()).containsAll((LongIterable)((COWLongSet)entry.getValue()).set())) continue;
                return false;
            }
        }
        if (set.myStringIds != null) {
            for (Map.Entry<String, COWBaseSet> entry : set.myStringIds.entrySet()) {
                if (((Set)((COWStringSet)entry.getValue()).set()).isEmpty()) continue;
                if (this.myStringIds == null) {
                    return false;
                }
                COWStringSet stringSet = this.myStringIds.get(entry.getKey());
                if (stringSet != null && ((Set)stringSet.set()).containsAll((Collection)((COWStringSet)entry.getValue()).set())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean add(ItemIdentity id) {
        boolean changed;
        this.checkImmutable();
        if (id == null) {
            throw new IllegalArgumentException("null id");
        }
        String itemType = id.getItemType();
        if (id.isLongId()) {
            Map<String, COWLongSet> map = this.ensureLongIdsMap(1);
            COWLongSet set = map.get(itemType);
            if (set == null) {
                set = new COWLongSet(id.getLongId());
                map.put(itemType, set);
                changed = true;
            } else {
                changed = set.add(id.getLongId());
            }
        } else {
            Map<String, COWStringSet> map = this.ensureStringIdsMap(1);
            COWStringSet set = map.get(itemType);
            if (set == null) {
                set = new COWStringSet(id.getStringId());
                map.put(itemType, set);
                changed = true;
            } else {
                changed = set.add(id.getStringId());
            }
        }
        if (changed) {
            ++this.myModCount;
        }
        return changed;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends ItemIdentity> c) {
        Map<String, COWBaseSet> map;
        this.checkImmutable();
        if (c == this) {
            return false;
        }
        if (!(c instanceof ItemIdentitySet)) {
            return super.addAll(c);
        }
        boolean modified = false;
        ItemIdentitySet set = (ItemIdentitySet)c;
        if (set.myLongIds != null) {
            map = this.ensureLongIdsMap(set.myLongIds.size());
            for (Map.Entry<String, COWBaseSet> entry : set.myLongIds.entrySet()) {
                COWLongSet longSet = (COWLongSet)map.get(entry.getKey());
                if (longSet == null) {
                    map.put(entry.getKey(), (COWLongSet)((COWLongSet)entry.getValue()).copy(this));
                    modified = true;
                    continue;
                }
                modified |= longSet.addAll((COWLongSet)entry.getValue());
            }
        }
        if (set.myStringIds != null) {
            map = this.ensureStringIdsMap(set.myStringIds.size());
            for (Map.Entry<String, COWBaseSet> entry : set.myStringIds.entrySet()) {
                COWStringSet stringSet = (COWStringSet)map.get(entry.getKey());
                if (stringSet == null) {
                    map.put(entry.getKey(), (COWStringSet)((COWStringSet)entry.getValue()).copy(this));
                    modified = true;
                    continue;
                }
                modified |= stringSet.addAll((COWStringSet)entry.getValue());
            }
        }
        if (modified) {
            ++this.myModCount;
        }
        return modified;
    }

    public void addAll(@NotNull String type, @NotNull Iterable<String> strings) {
        for (String id : strings) {
            this.add(ItemIdentity.stringId(type, id));
        }
    }

    public void addAll(@NotNull String type, @NotNull LongIterable longs) {
        for (LongIterator it : longs) {
            this.add(ItemIdentity.longId(type, it.value()));
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean removed;
        this.checkImmutable();
        if (!(o instanceof ItemIdentity)) {
            return false;
        }
        ItemIdentity id = (ItemIdentity)o;
        String itemType = id.getItemType();
        if (id.isLongId()) {
            if (this.myLongIds == null) {
                removed = false;
            } else {
                COWLongSet set = this.myLongIds.get(itemType);
                boolean bl = removed = set != null && set.remove(id.getLongId());
                if (removed && ((WritableLongSet)set.set()).isEmpty()) {
                    this.myLongIds.remove(itemType);
                }
            }
        } else if (this.myStringIds == null) {
            removed = false;
        } else {
            COWStringSet set = this.myStringIds.get(itemType);
            boolean bl = removed = set != null && set.remove(id.getStringId());
            if (removed && ((Set)set.set()).isEmpty()) {
                this.myStringIds.remove(itemType);
            }
        }
        if (removed) {
            ++this.myModCount;
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ItemIdentitySet copy = this.copy();
        boolean changed = false;
        for (ItemIdentity id : copy) {
            if (c.contains(id)) continue;
            this.remove(id);
            changed = true;
        }
        return changed;
    }

    public ItemIdentitySet makeImmutable() {
        this.myImmutable = true;
        return this;
    }

    public boolean isImmutable() {
        return this.myImmutable;
    }

    private void checkImmutable() {
        if (this.myImmutable) {
            throw new IllegalStateException(this + " is immutable");
        }
    }

    @Override
    public void clear() {
        this.checkImmutable();
        if (this.myLongIds != null) {
            this.myLongIds.clear();
        }
        if (this.myStringIds != null) {
            this.myStringIds.clear();
        }
        ++this.myModCount;
    }

    public Iterable<String> getItemTypes() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new TypesIterator();
            }
        };
    }

    @NotNull
    private Map<String, COWLongSet> ensureLongIdsMap(int initialSize) {
        if (this.myLongIds == null) {
            this.myLongIds = new HashMap<String, COWLongSet>(initialSize);
        }
        return this.myLongIds;
    }

    @NotNull
    private Map<String, COWStringSet> ensureStringIdsMap(int initialSize) {
        if (this.myStringIds == null) {
            this.myStringIds = new HashMap<String, COWStringSet>(initialSize);
        }
        return this.myStringIds;
    }

    public ItemIdentitySet copyAllOfType(String typeId) {
        COWBaseSet set;
        ItemIdentitySet r = new ItemIdentitySet();
        if (this.myLongIds != null && (set = this.myLongIds.get(typeId)) != null) {
            r.myLongIds = new HashMap<String, COWLongSet>(1);
            r.myLongIds.put(typeId, (COWLongSet)set.copy(r));
        }
        if (this.myStringIds != null && (set = this.myStringIds.get(typeId)) != null) {
            r.myStringIds = new HashMap<String, COWStringSet>(1);
            r.myStringIds.put(typeId, (COWStringSet)set.copy(r));
        }
        return r;
    }

    public ItemIdentitySet copy() {
        ItemIdentitySet r = new ItemIdentitySet();
        r.addAll(this);
        return r;
    }

    private WritableLongSet createLongSet(int capacity, Long addElement) {
        LongOpenHashSet set = new LongOpenHashSet(capacity);
        if (addElement != null) {
            set.addAll(new long[]{addElement});
        }
        return set;
    }

    private Set<String> createStringSet(int capacity, String addElement) {
        HashSet<String> set = new HashSet<String>(capacity);
        if (addElement != null) {
            set.add(addElement);
        }
        return set;
    }

    public LongSizedIterable longIds(String typeId) {
        COWLongSet set;
        COWLongSet cOWLongSet = set = this.myLongIds == null ? null : this.myLongIds.get(typeId);
        if (set == null) {
            return LongList.EMPTY;
        }
        return (LongSizedIterable)set.set();
    }

    public Set<String> stringIds(String typeId) {
        COWStringSet set;
        COWStringSet cOWStringSet = set = this.myStringIds == null ? null : this.myStringIds.get(typeId);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)set.set());
    }

    @NotNull
    public static Set<ItemIdentity> collectItemIds(@NotNull RowRetriever rowRetriever, @Nullable LongIterable rows) {
        if (rows == null) {
            return Collections.emptySet();
        }
        ItemIdentitySet r = new ItemIdentitySet();
        rowRetriever.scanRows(rows, false, ItemAccessMode.ITEM_NOT_NEEDED, RowRetriever.IGNORE_MISSING_ROWS, row -> {
            r.add(row.getItemId());
            return true;
        });
        return r;
    }

    private class RecollectingIterator
    extends AbstractIterator<ItemIdentity> {
        private final int myStartingModCount;
        private Iterator<Map.Entry<String, COWLongSet>> myLongIdsIterator;
        private Iterator<Map.Entry<String, COWStringSet>> myStringIdsIterator;
        private String myCurrentType;
        private LongIterator myCurrentLongIterator;
        private Iterator<String> myCurrentStringIterator;

        private RecollectingIterator() {
            this.myStartingModCount = ItemIdentitySet.this.myModCount;
            this.myLongIdsIterator = ItemIdentitySet.this.myLongIds == null ? Collections.emptyIterator() : ItemIdentitySet.this.myLongIds.entrySet().iterator();
            this.myStringIdsIterator = ItemIdentitySet.this.myStringIds == null ? Collections.emptyIterator() : ItemIdentitySet.this.myStringIds.entrySet().iterator();
        }

        protected ItemIdentity computeNext() {
            Map.Entry<String, COWBaseSet> next;
            if (ItemIdentitySet.this.myModCount != this.myStartingModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.myLongIdsIterator != null) {
                if (this.myCurrentLongIterator != null && this.myCurrentLongIterator.hasNext()) {
                    assert (this.myCurrentType != null) : this;
                    return ItemIdentity.longId(this.myCurrentType, this.myCurrentLongIterator.nextValue());
                }
                while (this.myLongIdsIterator.hasNext()) {
                    next = this.myLongIdsIterator.next();
                    this.myCurrentType = next.getKey();
                    this.myCurrentLongIterator = ((WritableLongSet)((COWLongSet)next.getValue()).set()).iterator();
                    if (!this.myCurrentLongIterator.hasNext()) continue;
                    return ItemIdentity.longId(this.myCurrentType, this.myCurrentLongIterator.nextValue());
                }
                this.myCurrentLongIterator = null;
                this.myLongIdsIterator = null;
            }
            if (this.myStringIdsIterator != null) {
                if (this.myCurrentStringIterator != null && this.myCurrentStringIterator.hasNext()) {
                    assert (this.myCurrentType != null) : this;
                    return ItemIdentity.stringId(this.myCurrentType, this.myCurrentStringIterator.next());
                }
                while (this.myStringIdsIterator.hasNext()) {
                    next = this.myStringIdsIterator.next();
                    this.myCurrentType = next.getKey();
                    this.myCurrentStringIterator = ((Set)((COWStringSet)next.getValue()).set()).iterator();
                    if (!this.myCurrentStringIterator.hasNext()) continue;
                    return ItemIdentity.stringId(this.myCurrentType, this.myCurrentStringIterator.next());
                }
                this.myCurrentStringIterator = null;
                this.myStringIdsIterator = null;
            }
            return (ItemIdentity)this.endOfData();
        }
    }

    private class COWLongSet
    extends COWBaseSet<WritableLongSet, COWLongSet> {
        public COWLongSet(WritableLongSet set, boolean copyOnWrite) {
            super(set, copyOnWrite);
        }

        public COWLongSet(long id) {
            super(ItemIdentitySet.this.createLongSet(10, id), false);
        }

        @Override
        protected WritableLongSet makeCopy(WritableLongSet set, int additionalSize) {
            WritableLongSet newSet = ItemIdentitySet.this.createLongSet(set.size() + additionalSize, null);
            newSet.addAll((LongIterable)set);
            return newSet;
        }

        @Override
        protected COWLongSet createInstance(WritableLongSet set, boolean copyOnWrite, ItemIdentitySet owner) {
            ItemIdentitySet itemIdentitySet = owner;
            Objects.requireNonNull(itemIdentitySet);
            return itemIdentitySet.new COWLongSet(set, copyOnWrite);
        }

        public boolean addAll(COWLongSet value) {
            this.maybeCopy(((WritableLongSet)value.set()).size());
            WritableLongSet set = (WritableLongSet)this.set();
            int sizeBefore = set.size();
            set.addAll((LongIterable)value.set());
            return sizeBefore != set.size();
        }

        public boolean add(long id) {
            this.maybeCopy(1);
            return ((WritableLongSet)this.set()).include(id);
        }

        public boolean remove(long id) {
            this.maybeCopy(0);
            return ((WritableLongSet)this.set()).exclude(id);
        }
    }

    private class COWStringSet
    extends COWBaseSet<Set<String>, COWStringSet> {
        public COWStringSet(Set<String> set, boolean copyOnWrite) {
            super(set, copyOnWrite);
        }

        public COWStringSet(String id) {
            super(ItemIdentitySet.this.createStringSet(10, id), false);
        }

        @Override
        protected Set<String> makeCopy(Set<String> set, int additionalSize) {
            Set newSet = ItemIdentitySet.this.createStringSet(set.size() + additionalSize, null);
            newSet.addAll(set);
            return newSet;
        }

        @Override
        protected COWStringSet createInstance(Set<String> set, boolean copyOnWrite, ItemIdentitySet owner) {
            ItemIdentitySet itemIdentitySet = owner;
            Objects.requireNonNull(itemIdentitySet);
            return itemIdentitySet.new COWStringSet(set, copyOnWrite);
        }

        public boolean addAll(COWStringSet value) {
            this.maybeCopy(((Set)value.set()).size());
            return ((Set)this.set()).addAll((Collection)value.set());
        }

        public boolean add(String id) {
            this.maybeCopy(1);
            return ((Set)this.set()).add(id);
        }

        public boolean remove(String id) {
            this.maybeCopy(0);
            return ((Set)this.set()).remove(id);
        }
    }

    private abstract class COWBaseSet<T, S extends COWBaseSet<T, S>> {
        @NotNull
        private T mySet;
        private boolean myCopyOnWrite;

        public COWBaseSet(T set, boolean copyOnWrite) {
            this.mySet = set;
            this.myCopyOnWrite = copyOnWrite;
        }

        protected abstract T makeCopy(T var1, int var2);

        protected abstract S createInstance(T var1, boolean var2, ItemIdentitySet var3);

        public T set() {
            return this.mySet;
        }

        public S copy(ItemIdentitySet owner) {
            T copied = this.set();
            if (this.isSafeToReuse()) {
                return this.createInstance(copied, true, owner);
            }
            return this.createInstance(this.makeCopy(copied, 0), false, owner);
        }

        protected boolean isSafeToReuse() {
            return ItemIdentitySet.this.myImmutable || this.myCopyOnWrite;
        }

        protected void maybeCopy(int additionalSize) {
            if (this.myCopyOnWrite) {
                this.mySet = this.makeCopy(this.mySet, additionalSize);
                this.myCopyOnWrite = false;
            }
        }
    }

    private class TypesIterator
    extends AbstractIterator<String> {
        private final int myStartingModCount;
        private Iterator<String> myLongKeysIterator;
        private Iterator<String> myStringIdsIterator;

        private TypesIterator() {
            this.myStartingModCount = ItemIdentitySet.this.myModCount;
            this.myLongKeysIterator = ItemIdentitySet.this.myLongIds == null ? Collections.emptyIterator() : ItemIdentitySet.this.myLongIds.keySet().iterator();
            this.myStringIdsIterator = ItemIdentitySet.this.myStringIds == null ? Collections.emptyIterator() : ItemIdentitySet.this.myStringIds.keySet().iterator();
        }

        protected String computeNext() {
            if (ItemIdentitySet.this.myModCount != this.myStartingModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.myLongKeysIterator != null) {
                if (this.myLongKeysIterator.hasNext()) {
                    return this.myLongKeysIterator.next();
                }
                this.myLongKeysIterator = null;
            }
            if (this.myStringIdsIterator != null) {
                while (this.myStringIdsIterator.hasNext()) {
                    String type = this.myStringIdsIterator.next();
                    if (ItemIdentitySet.this.myLongIds != null && ItemIdentitySet.this.myLongIds.containsKey(type)) continue;
                    return type;
                }
                this.myStringIdsIterator = null;
            }
            return (String)this.endOfData();
        }
    }
}

