/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.effect;

import com.almworks.jira.structure.api.util.JsonMapUtil;
import com.atlassian.annotations.PublicApi;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public final class StoredEffect {
    @NotNull
    private final String myModuleKey;
    @NotNull
    private final Map<String, Object> myParameters;

    @JsonCreator
    public StoredEffect(@JsonProperty(value="moduleKey") @NotNull String moduleKey, @JsonProperty(value="parameters") @NotNull Map<String, Object> parameters) {
        this.myModuleKey = moduleKey;
        this.myParameters = JsonMapUtil.copyParameters(parameters, false, true, true);
    }

    @NotNull
    public String getModuleKey() {
        return this.myModuleKey;
    }

    @NotNull
    public Map<String, Object> getParameters() {
        return this.myParameters;
    }

    @NotNull
    public static Builder builder(@NotNull String moduleKey) {
        return new Builder(moduleKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredEffect effect = (StoredEffect)o;
        return this.myModuleKey.equals(effect.myModuleKey) && this.myParameters.equals(effect.myParameters);
    }

    public String toString() {
        return "StoredEffect{myModuleKey='" + this.myModuleKey + '\'' + ", myParameters=" + this.myParameters + '}';
    }

    public int hashCode() {
        return Objects.hash(this.myModuleKey, this.myParameters);
    }

    public static final class Builder {
        @NotNull
        private String myModuleKey;
        @NotNull
        private final Map<String, Object> myParameters = new HashMap<String, Object>();

        public Builder(@NotNull String moduleKey) {
            this.myModuleKey = moduleKey;
        }

        public Builder(@NotNull StoredEffect storedEffect) {
            this.myModuleKey = storedEffect.getModuleKey();
            this.myParameters.putAll(storedEffect.getParameters());
        }

        @NotNull
        public Builder setModuleKey(@NotNull String moduleKey) {
            this.myModuleKey = moduleKey;
            return this;
        }

        @NotNull
        public Builder setParameter(@NotNull String key, @Nullable Object value) {
            if (value != null) {
                this.myParameters.put(key, value);
            } else {
                this.myParameters.remove(key);
            }
            return this;
        }

        @NotNull
        public StoredEffect build() {
            return new StoredEffect(this.myModuleKey, this.myParameters);
        }
    }
}

