/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.auth;

import com.almworks.jira.structure.api.auth.AuthContext;
import com.almworks.jira.structure.api.util.CallableE;
import com.almworks.jira.structure.api.util.JiraComponents;
import com.almworks.jira.structure.api.util.JiraUsers;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.log.Log4jKit;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.MDC;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureAuth {
    private static final Logger log = LoggerFactory.getLogger(StructureAuth.class);
    private static final ThreadLocal<Pair<Option<ApplicationUser>, Boolean>> sudoContext = new ThreadLocal();
    private static final AtomicBoolean reportedNoAuthContext = new AtomicBoolean();

    @Nullable
    public static ApplicationUser getUser() {
        Pair<Option<ApplicationUser>, Boolean> context = sudoContext.get();
        return context == null ? StructureAuth.getJiraUser() : (ApplicationUser)((Option)context.left()).getOrNull();
    }

    @Nullable
    public static String getUserKey() {
        return JiraUsers.getKeyFor(StructureAuth.getUser());
    }

    @Nullable
    private static ApplicationUser getJiraUser() {
        JiraAuthenticationContext jiraContext = JiraComponents.getJiraAuthenticationContext();
        if (jiraContext == null) {
            if (reportedNoAuthContext.compareAndSet(false, true)) {
                log.error("JIRA's ComponentAccessor does not provide authentication context. Structure will behave as if everything is executed under anonymous user.");
            }
            return null;
        }
        return jiraContext.getLoggedInUser();
    }

    public static boolean isSecurityOverridden() {
        Pair<Option<ApplicationUser>, Boolean> context = sudoContext.get();
        return context != null && (Boolean)context.right() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, E extends Exception> R sudo(@Nullable ApplicationUser user, boolean overrideSecurity, CallableE<R, E> f) throws E {
        JiraAuthenticationContext jiraContext = JiraComponents.getJiraAuthenticationContext();
        ApplicationUser oldUser = jiraContext.getLoggedInUser();
        boolean sameUser = Objects.equals(user, oldUser);
        Pair<Option<ApplicationUser>, Boolean> oldContext = sudoContext.get();
        Boolean securityOverridden = oldContext != null && (Boolean)oldContext.right() != false;
        if (sameUser && Objects.equals(overrideSecurity, securityOverridden)) {
            return f.call();
        }
        sudoContext.set((Pair<Option<ApplicationUser>, Boolean>)Pair.pair((Object)Option.option((Object)user), (Object)overrideSecurity));
        jiraContext.setLoggedInUser(user);
        String oldLoggingUsername = StructureAuth.getOldLoggingUsername(oldUser);
        Log4jKit.putUserToMDC((String)StructureAuth.getNewLoggingUsername(user, oldLoggingUsername, sameUser));
        try {
            R r = f.call();
            return r;
        }
        finally {
            if (oldContext != null) {
                sudoContext.set(oldContext);
            } else {
                sudoContext.remove();
            }
            jiraContext.setLoggedInUser(oldUser);
            Log4jKit.putUserToMDC((String)oldLoggingUsername);
        }
    }

    private static String getNewLoggingUsername(@Nullable ApplicationUser user, @NotNull String oldLoggingUsername, boolean sameUser) {
        return sameUser ? oldLoggingUsername : StructureAuth.getDisplayedUserName(user) + "<-" + oldLoggingUsername;
    }

    @NotNull
    private static String getOldLoggingUsername(ApplicationUser oldUser) {
        Object obj = MDC.get((String)"jira.username");
        if (obj != null) {
            return obj.toString();
        }
        return StructureAuth.getDisplayedUserName(oldUser);
    }

    private static String getDisplayedUserName(@Nullable ApplicationUser user) {
        return user == null ? "anonymous" : user.getName();
    }

    public static <R, E extends Exception> R sudo(CallableE<R, E> f) throws E {
        return StructureAuth.sudo(StructureAuth.getUser(), true, f);
    }

    public static AuthContext currentContext() {
        Pair<Option<ApplicationUser>, Boolean> context = sudoContext.get();
        return context == null ? new AuthContext.Custom(StructureAuth.getJiraUser(), false) : new AuthContext.Custom((ApplicationUser)((Option)context.left()).getOrNull(), (Boolean)context.right());
    }
}

