/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.darkfeature.DarkFeatures;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public abstract class TrailItemSet {
    @Internal
    @VisibleForTesting
    static int SPECIFIC_ITEMS_LIMIT = DarkFeatures.getInteger("structure.trail.itemLimit", 50);
    @Internal
    @VisibleForTesting
    static int SPECIFIC_TYPES_LIMIT = DarkFeatures.getInteger("structure.trail.typeLimit", 10);
    private int myHashCode;

    private TrailItemSet() {
    }

    public abstract boolean contains(@Nullable ItemIdentity var1);

    public boolean containsAny(@Nullable Collection<ItemIdentity> itemIds) {
        if (itemIds == null) {
            return false;
        }
        return itemIds.stream().anyMatch(this::contains);
    }

    @NotNull
    public abstract TrailItemSet expand(@Nullable ItemIdentity var1);

    @NotNull
    public abstract TrailItemSet union(@Nullable TrailItemSet var1);

    public abstract void accept(@NotNull Visitor var1);

    public final boolean isEmpty() {
        return this.cardinality() == 0;
    }

    abstract int cardinality();

    public final boolean equals(Object obj) {
        if (!(obj instanceof TrailItemSet)) {
            return false;
        }
        TrailItemSet that = (TrailItemSet)obj;
        if (this.cardinality() != that.cardinality()) {
            return false;
        }
        return Collector.collect(this).equals(Collector.collect(that));
    }

    public final int hashCode() {
        int hashCode = this.myHashCode;
        if (hashCode == 0) {
            hashCode = Collector.collect(this).hashCode();
            if (hashCode == 0) {
                hashCode = -1;
            }
            this.myHashCode = hashCode;
        }
        return hashCode;
    }

    public String toString() {
        return Collector.collect(this).toString();
    }

    public static TrailItemSet of(ItemIdentity ... ids) {
        return TrailItemSet.of(Arrays.asList(ids));
    }

    public static TrailItemSet of(Collection<ItemIdentity> ids) {
        Set<ItemIdentity> idsSet = TrailItemSet.toSetWithoutNulls(ids);
        if (idsSet == null || idsSet.size() == 0) {
            return None.NONE;
        }
        if (idsSet.size() == 1) {
            return new OneItem(ids.iterator().next());
        }
        if (idsSet.size() <= SPECIFIC_ITEMS_LIMIT) {
            return new SpecificItems(idsSet);
        }
        return TrailItemSet.createFromTypes(TrailItemSet.converterItemsToItemTypes(idsSet));
    }

    public static TrailItemSet ofTypes(Collection<String> types) {
        if (types == null) {
            return None.NONE;
        }
        return TrailItemSet.createFromTypes(TrailItemSet.toSetWithoutNulls(types));
    }

    private static TrailItemSet createFromTypes(@NotNull Set<String> typesSet) {
        if (typesSet.isEmpty()) {
            return None.NONE;
        }
        if (typesSet.size() == 1) {
            return new OneType(typesSet.iterator().next());
        }
        if (typesSet.size() <= SPECIFIC_TYPES_LIMIT) {
            return new SpecificTypes(typesSet);
        }
        return AllItems.ALL_ITEMS;
    }

    private static Set<String> converterItemsToItemTypes(@NotNull Set<ItemIdentity> items) {
        return items.stream().map(id -> id == null ? null : id.getItemType()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static <T> Set<T> toSetWithoutNulls(Collection<T> collection) {
        return collection == null ? null : collection.stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    static TrailItemSet of(Collection<ItemIdentity> ids, ItemIdentity itemIdentity) {
        ArrayList<ItemIdentity> itemIdentities = new ArrayList<ItemIdentity>(ids.size() + 1);
        itemIdentities.addAll(ids);
        itemIdentities.add(itemIdentity);
        return TrailItemSet.of(itemIdentities);
    }

    static TrailItemSet ofTypes(Collection<String> typesCollectionA, Collection<String> typesCollectionB) {
        return TrailItemSet.createFromTypes(Stream.concat(typesCollectionA.stream(), typesCollectionB.stream()).collect(Collectors.toSet()));
    }

    static TrailItemSet ofTypes(Collection<String> typesCollectionA, String oneMoreType) {
        return TrailItemSet.createFromTypes(Stream.concat(typesCollectionA.stream(), Stream.of(oneMoreType)).collect(Collectors.toSet()));
    }

    public static class Collector
    implements ReadVisitor {
        private Set<String> myTypes;
        private Set<ItemIdentity> myItems;
        private boolean myAll;

        private Collector(int cardinality) {
            if (cardinality > 0 && cardinality < Integer.MAX_VALUE) {
                this.myItems = new HashSet<ItemIdentity>(cardinality);
            } else if (cardinality < 0) {
                this.myTypes = new HashSet<String>(-cardinality);
            }
        }

        public static Collector collect(TrailItemSet set) {
            Collector collector = new Collector(set.cardinality());
            set.accept(collector);
            return collector;
        }

        public Set<String> getTypes() {
            return this.myTypes;
        }

        public Set<ItemIdentity> getItems() {
            return this.myItems;
        }

        public boolean isAll() {
            return this.myAll;
        }

        @Override
        public void visitItem(ItemIdentity item) {
            if (this.myItems == null) {
                assert (false) : "set reported bad cardinality [" + item + "]";
                this.myItems = new HashSet<ItemIdentity>();
            }
            this.myItems.add(item);
        }

        @Override
        public void visitType(String type) {
            if (this.myTypes == null) {
                assert (false) : "set reported bad cardinality [" + type + "]";
                this.myTypes = new HashSet<String>();
            }
            this.myTypes.add(type);
        }

        @Override
        public void visitAll() {
            this.myAll = true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Collector collector = (Collector)o;
            return this.myAll == collector.myAll && Objects.equals(this.myTypes, collector.myTypes) && Objects.equals(this.myItems, collector.myItems);
        }

        public int hashCode() {
            return Objects.hash(this.myTypes, this.myItems, this.myAll);
        }

        public String toString() {
            if (this.myAll) {
                return "{ALL}";
            }
            String types = this.myTypes == null ? "" : StringUtils.join(this.myTypes, (char)',');
            String items = this.myItems == null ? "" : StringUtils.join(this.myItems, (char)',');
            String comma = types != null && items != null ? "," : "";
            return "{" + types + comma + items + "}";
        }
    }

    public static final class None
    extends TrailItemSet {
        public static final TrailItemSet NONE = new None();

        @Override
        public boolean contains(ItemIdentity id) {
            return false;
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable ItemIdentity trailItem) {
            if (trailItem == null) {
                return this;
            }
            return new OneItem(trailItem);
        }

        @Override
        @NotNull
        public TrailItemSet union(@Nullable TrailItemSet anotherSet) {
            if (anotherSet == null) {
                return this;
            }
            return anotherSet;
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visitNone();
        }

        @Override
        int cardinality() {
            return 0;
        }

        @Override
        public String toString() {
            return "{}";
        }
    }

    public static final class OneItem
    extends TrailItemSet {
        private final ItemIdentity myItem;

        private OneItem(ItemIdentity item) {
            this.myItem = item;
        }

        @Override
        public boolean contains(ItemIdentity id) {
            return id != null && id.equals(this.myItem);
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable ItemIdentity trailItem) {
            if (trailItem == null || trailItem.equals(this.myItem)) {
                return this;
            }
            return OneItem.of(this.myItem, trailItem);
        }

        @Override
        @NotNull
        public TrailItemSet union(@Nullable TrailItemSet anotherSet) {
            if (anotherSet == null) {
                return this;
            }
            return anotherSet.expand(this.myItem);
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        int cardinality() {
            return 1;
        }

        @NotNull
        public ItemIdentity getItem() {
            return this.myItem;
        }
    }

    public static final class SpecificItems
    extends TrailItemSet {
        @NotNull
        private final Set<ItemIdentity> myItems;

        private SpecificItems(Set<ItemIdentity> itemsSet) {
            this.myItems = Collections.unmodifiableSet(itemsSet);
        }

        @Override
        public boolean contains(ItemIdentity id) {
            return this.myItems.contains(id);
        }

        @NotNull
        public Set<ItemIdentity> getItems() {
            return this.myItems;
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable ItemIdentity trailItem) {
            if (trailItem == null || this.myItems.contains(trailItem)) {
                return this;
            }
            return SpecificItems.of(this.myItems, trailItem);
        }

        @Override
        @NotNull
        public TrailItemSet union(@Nullable TrailItemSet anotherSet) {
            if (anotherSet == null || anotherSet == None.NONE) {
                return this;
            }
            if (anotherSet == AllItems.ALL_ITEMS) {
                return anotherSet;
            }
            if (anotherSet.cardinality() < 0) {
                return SpecificItems.ofTypes(Collector.collect(anotherSet).getTypes(), TrailItemSet.converterItemsToItemTypes(this.myItems));
            }
            HashSet<ItemIdentity> collectTrailItems = new HashSet<ItemIdentity>(this.myItems);
            collectTrailItems.addAll(Collector.collect(anotherSet).getItems());
            return SpecificItems.of(collectTrailItems);
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        int cardinality() {
            return this.myItems.size();
        }
    }

    public static final class OneType
    extends TrailItemSet {
        private final String myItemType;

        private OneType(String itemType) {
            this.myItemType = itemType;
        }

        @NotNull
        public String getItemType() {
            return this.myItemType;
        }

        @Override
        public boolean contains(ItemIdentity id) {
            return id != null && id.getItemType().equals(this.myItemType);
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable ItemIdentity trailItem) {
            if (trailItem == null) {
                return this;
            }
            String itemType = trailItem.getItemType();
            if (itemType.equals(this.myItemType)) {
                return this;
            }
            return OneType.ofTypes(Arrays.asList(this.myItemType, itemType));
        }

        @Override
        @NotNull
        public TrailItemSet union(@Nullable TrailItemSet anotherSet) {
            if (anotherSet == null || anotherSet == None.NONE) {
                return this;
            }
            if (anotherSet.cardinality() < 0) {
                if (anotherSet instanceof OneType) {
                    String otherItemType = ((OneType)anotherSet).myItemType;
                    if (this.myItemType.equals(otherItemType)) {
                        return this;
                    }
                    return OneType.ofTypes(Arrays.asList(this.myItemType, otherItemType));
                }
                return OneType.ofTypes(Collector.collect(anotherSet).getTypes(), this.myItemType);
            }
            return anotherSet.union(this);
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        int cardinality() {
            return -1;
        }
    }

    public static final class SpecificTypes
    extends TrailItemSet {
        @NotNull
        private final Set<String> myTypes;

        private SpecificTypes(Set<String> types) {
            this.myTypes = Collections.unmodifiableSet(types);
        }

        @Override
        public boolean contains(ItemIdentity id) {
            return id != null && this.myTypes.contains(id.getItemType());
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable ItemIdentity trailItem) {
            if (trailItem == null || this.myTypes.contains(trailItem.getItemType())) {
                return this;
            }
            return SpecificTypes.ofTypes(this.myTypes, trailItem.getItemType());
        }

        @Override
        @NotNull
        public TrailItemSet union(@Nullable TrailItemSet anotherSet) {
            if (anotherSet == null || anotherSet == None.NONE) {
                return this;
            }
            if (anotherSet.cardinality() < 0) {
                if (anotherSet instanceof OneType) {
                    String otherItemType = ((OneType)anotherSet).getItemType();
                    if (this.myTypes.contains(otherItemType)) {
                        return this;
                    }
                    return SpecificTypes.ofTypes(this.myTypes, otherItemType);
                }
                return SpecificTypes.ofTypes(this.myTypes, Collector.collect(anotherSet).getTypes());
            }
            return anotherSet.union(this);
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        int cardinality() {
            return -this.myTypes.size();
        }

        @NotNull
        public Set<String> getTypes() {
            return this.myTypes;
        }
    }

    public static final class AllItems
    extends TrailItemSet {
        public static final TrailItemSet ALL_ITEMS = new AllItems();

        @Override
        public boolean contains(ItemIdentity id) {
            return true;
        }

        @Override
        @NotNull
        public TrailItemSet expand(ItemIdentity trailItem) {
            return this;
        }

        @Override
        @NotNull
        public TrailItemSet union(@Nullable TrailItemSet anotherSet) {
            return this;
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visitAll();
        }

        @Override
        int cardinality() {
            return Integer.MAX_VALUE;
        }
    }

    public static interface ReadVisitor
    extends Visitor {
        public void visitItem(ItemIdentity var1);

        public void visitType(String var1);

        @Override
        default public void visitNone() {
        }

        @Override
        default public void visit(OneItem set) {
            this.visitItem(set.getItem());
        }

        @Override
        default public void visit(SpecificItems set) {
            for (ItemIdentity item : set.getItems()) {
                this.visitItem(item);
            }
        }

        @Override
        default public void visit(OneType set) {
            this.visitType(set.getItemType());
        }

        @Override
        default public void visit(SpecificTypes set) {
            for (String type : set.getTypes()) {
                this.visitType(type);
            }
        }
    }

    public static interface Visitor {
        public void visitNone();

        public void visit(OneItem var1);

        public void visit(SpecificItems var1);

        public void visit(OneType var1);

        public void visit(SpecificTypes var1);

        public void visitAll();
    }
}

