package com.almworks.jira.structure.api.process;

import com.almworks.jira.structure.api.util.I18nText;
import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.Nullable;

/**
 * <p><b>ProcessInfo</b> allows communication between process owner and process itself.</p>
 *
 * <p>If you know processId, you can access its state using {@link ProcessHandleManager#getInfo(Long)} method.</p>
 */
public interface ProcessInfo {
  /**
   * @return Actual status of the process. Null if there is no such process
   */
  @Nullable
  ProcessStatus getStatus();

  /**
   * @return Process display parameters (process name, buttons). Null if there is no such process
   */
  @Nullable
  ProcessDisplayParameters getParameters();

  /**
   * @param user User key
   * @return true if state is visible for the user. false if there is no such process
   */
  boolean isVisibleTo(@Nullable ApplicationUser user);

  /**
   * @return A short description of the current activity. Null if there is no such process.
   */
  @Nullable
  I18nText getActivity();

  /**
   * @return Process completion percentage, 0 to 100. -1 if progress is unknown/indeterminate or there is no such process
   */
  int getPercentComplete();

  /**
   * Ask the process to stop. It's up to the process to decide what to do about this request.
   * No effect if there is no such process.
   */
  void cancel();
}
