package com.almworks.jira.structure.api.effector.instance;

import com.almworks.jira.structure.api.effector.Effector;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

/**
 * An effector instance is a persistent entity, containing an {@link Effector}
 * module key and its parameters. Effector instances are installed into
 * structure skeletons as rows.
 */
@PublicApi
public interface EffectorInstance {
  /**
   * @return the ID of this instance
   */
  long getId();

  /**
   * @return the module key of the {@link Effector}
   */
  @NotNull
  String getModuleKey();

  /**
   * @return effector-specific parameters
   */
  @NotNull
  Map<String, Object> getParameters();

  /**
   * @return the ID of the structure this effector instance is installed into,
   * if applicable
   */
  @Nullable
  Long getOwningStructure();
}
