package com.almworks.jira.structure.api.backup;

import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public interface BackupWriter {
  void writeStartElement(@NotNull String localName);

  void writeEndElement();

  void writeElement(@NotNull String localName, @Nullable String text);

  void writeAttribute(@NotNull String localName, @NotNull String value);

  void writeCharacters(@NotNull String text);
}
