package com.almworks.jira.structure.api.attribute.subscription;

import com.almworks.integers.LongList;
import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.forest.ForestSpec;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

/**
 * <p>Provides methods for changing {@link AttributeSubscription} parameters.</p>
 *
 * <p>All methods may be called in any order. The actual update of the parameters will happen only after all the calls have been done.</p>
 *
 * @see AttributeSubscription#changeSubscription
 */
@PublicApi
public interface AttributeSubscriptionPatch {
  @NotNull
  AttributeSubscriptionPatch setForest(ForestSpec forestSpec);

  @NotNull
  AttributeSubscriptionPatch setAttributes(Collection<? extends AttributeSpec<?>> attributes);

  @NotNull
  AttributeSubscriptionPatch setRows(LongList rows);

  @NotNull
  AttributeSubscriptionPatch addAttribute(AttributeSpec<?> attribute);

  @NotNull
  AttributeSubscriptionPatch removeAttribute(AttributeSpec<?> attribute);

  @NotNull
  AttributeSubscriptionPatch addRows(LongList rows);

  @NotNull
  AttributeSubscriptionPatch removeRows(LongList rows);
}
