package com.almworks.jira.structure.api.attribute;

import com.atlassian.annotations.PublicApi;

import static com.almworks.jira.structure.api.attribute.ValueFormat.DURATION;

/**
 * {@code CoreAttributeSpec} contains the attribute specifications and related constants for the well-known attributes.
 *
 * @see AttributeSpec
 */
@PublicApi
public class SharedAttributeSpecs {
  public static final AttributeSpec<String> ID = new AttributeSpec<>("id", ValueFormat.ID);

  public static final AttributeSpec<String> KEY = new AttributeSpec<>(Id.KEY, ValueFormat.TEXT);
  public static final AttributeSpec<String> SUMMARY = new AttributeSpec<>(Id.SUMMARY, ValueFormat.TEXT);
  public static final AttributeSpec<String> DESCRIPTION = new AttributeSpec<>(Id.DESCRIPTION, ValueFormat.HTML);
  public static final AttributeSpec<String> URL = new AttributeSpec<>(Id.URL, ValueFormat.TEXT);
  /**
   * A HTML that represents an icon of this item like '&lt;img src="..."/&gt;', or any other HTML.
   */
  public static final AttributeSpec<String> ICON = new AttributeSpec<>(Id.ICON, ValueFormat.HTML);

  /**
   * One-line text that can represent this item, for example, in a list. Similar to Summary but may contain more details.
   */
  public static final AttributeSpec<String> DISPLAYABLE_TEXT = new AttributeSpec<>(Id.DISPLAYABLE, ValueFormat.TEXT);

  public static final AttributeSpec<Boolean> DONE = new AttributeSpec<>(Id.DONE, ValueFormat.BOOLEAN);
  public static final AttributeSpec<Boolean> EDITABLE = new AttributeSpec<>(Id.EDITABLE, ValueFormat.BOOLEAN);

  public static final AttributeSpec<String> PROJECT_ID = new AttributeSpec<>(Id.PROJECT, ValueFormat.ID);
  public static final AttributeSpec<String> ISSUETYPE_ID = new AttributeSpec<>(Id.ISSUETYPE, ValueFormat.ID);
  public static final AttributeSpec<String> STATUS_ID = new AttributeSpec<>(Id.STATUS, ValueFormat.ID);

  public static final AttributeSpec<Number> VOTES = new AttributeSpec<>(Id.VOTES, ValueFormat.NUMBER);
  public static final AttributeSpec<Number> WATCHES = new AttributeSpec<>(Id.WATCHES, ValueFormat.NUMBER);

  public static final AttributeSpec<Long> TIME_SPENT = new AttributeSpec<>("timespent", ValueFormat.DURATION);
  public static final AttributeSpec<Long> ORIGINAL_ESTIMATE = new AttributeSpec<>("timeoriginalestimate", ValueFormat.DURATION);
  public static final AttributeSpec<Long> REMAINING_ESTIMATE = new AttributeSpec<>("timeestimate", ValueFormat.DURATION);

  public static final AttributeSpec<Long> TOTAL_TIME_SPENT =
    AttributeSpecBuilder.create(Id.SUM, DURATION).params().setAttribute(TIME_SPENT).set(Param.DISTINCT, true).build();
  public static final AttributeSpec<Long> TOTAL_ORIGINAL_ESTIMATE =
    AttributeSpecBuilder.create(Id.SUM, DURATION).params().setAttribute(ORIGINAL_ESTIMATE).set(Param.DISTINCT, true).build();
  public static final AttributeSpec<Long> TOTAL_REMAINING_ESTIMATE =
    AttributeSpecBuilder.create(Id.SUM, DURATION).params().setAttribute(REMAINING_ESTIMATE).set(Param.DISTINCT, true).build();

  protected SharedAttributeSpecs() {}


  public static class Id {
    public static final String DISPLAYABLE = "displayable";
    public static final String PRIORITY = "priority";
    public static final String PROJECT = "project";
    public static final String USER = "user";
    public static final String ASSIGNEE = "assignee";
    public static final String REPORTER = "reporter";
    public static final String TYPE = "type"; // this is not necessarily issue type!
    public static final String ISSUETYPE = "issuetype";
    public static final String STATUS = "status";
    public static final String SUMMARY = "summary";
    public static final String DESCRIPTION = "description";
    public static final String URL = "url";
    public static final String KEY = "key";
    public static final String DONE = "done";
    public static final String EDITABLE = "editable";
    public static final String VOTES = "votes";
    public static final String WATCHES = "watches";
    public static final String PROGRESS = "progress";
    public static final String SUM = "sum";
    public static final String ICON = "icon";

    protected Id() {}
  }


  public static class Param {
    public static final String DISTINCT = "distinct";
    public static final String ATTRIBUTE = "attribute";
    public static final String ID = "id";
    public static final String PARAMS = "params";
    public static final String FORMAT = "format";
    public static final String CHILDREN = "children";
    public static final String LEAVES = "leaves";
    public static final String STRICT = "strict";
    public static final String SUBTREE = "subtree";
    public static final String ANCESTORS = "ancestors";
    public static final String TYPE = "type";
    public static final String PRECEDING = "preceding";

    /*
      Standard parameters for scanning loaders:
      - levels defines at which depths we consider the values; could be used to skip parts of a structure
      - baseLevel level defines the level at which we aggregate the values, a row at a higher level will restart the aggregation
    */
    public static final String LEVELS = "levels";
    public static final String BASE_LEVEL = "baseLevel";

    protected Param() {}
  }
}
