/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.error;

import com.almworks.jira.structure.api.error.StructureError;
import com.almworks.jira.structure.api.error.StructureErrorCategory;
import com.atlassian.annotations.PublicApi;

@StructureError.CodeRange(from=0, to=6999)
@PublicApi
public enum StructureErrors implements StructureError
{
    GENERIC_ERROR(1000, StructureErrorCategory.GENERAL),
    LICENSE_PROBLEM(1003, StructureErrorCategory.GENERAL),
    LOCK_FAILED(1004, StructureErrorCategory.INTERNAL),
    INVALID_PARAMETER(2400, StructureErrorCategory.INVALID_INPUT),
    DECISION_REQUIRED(2401, StructureErrorCategory.GENERAL),
    FOREST_SOURCE_ACTION_FAILED(2402, StructureErrorCategory.GENERAL),
    UPDATE_ITEM_FAILED(2403, StructureErrorCategory.GENERAL),
    CREATE_ITEM_FAILED(2404, StructureErrorCategory.GENERAL),
    FOREST_CHANGE_PROHIBITED_BY_PARENT_PERMISSIONS(4002, StructureErrorCategory.NO_PERMISSION),
    PROJECT_NOT_ENABLED_FOR_STRUCTURE(4003, StructureErrorCategory.NO_PERMISSION),
    STRUCTURE_NOT_EXISTS_OR_NOT_ACCESSIBLE(4005, StructureErrorCategory.NOT_FOUND),
    NOT_ALLOWED_TO_CREATE_STRUCTURE(4006, StructureErrorCategory.NO_PERMISSION),
    STRUCTURE_ADMIN_DENIED(4007, StructureErrorCategory.NO_PERMISSION),
    STRUCTURE_EDIT_DENIED(4008, StructureErrorCategory.NO_PERMISSION),
    JIRA_ADMIN_DENIED(4009, StructureErrorCategory.NO_PERMISSION),
    STRUCTURE_PLUGIN_ACCESS_DENIED(4010, StructureErrorCategory.NO_PERMISSION),
    ARCHIVED_STRUCTURE_EDIT_DENIED(4012, StructureErrorCategory.NO_PERMISSION),
    STRUCTURE_OWNER_EDIT_DENIED(4013, StructureErrorCategory.NO_PERMISSION),
    STRUCTURE_AUTOMATION_EDIT_DENIED(4014, StructureErrorCategory.NO_PERMISSION),
    VIEW_NOT_EXISTS_OR_NOT_ACCESSIBLE(4101, StructureErrorCategory.NOT_FOUND),
    VIEW_ADMIN_DENIED(4102, StructureErrorCategory.NO_PERMISSION),
    VIEW_EDIT_DENIED(4103, StructureErrorCategory.NO_PERMISSION),
    VIEW_CREATION_DENIED(4104, StructureErrorCategory.NO_PERMISSION),
    PERSPECTIVE_CREATION_DENIED(4201, StructureErrorCategory.NO_PERMISSION),
    ITEM_EDIT_DENIED(4403, StructureErrorCategory.NO_PERMISSION),
    AUTOMATION_ACCESS_DENIED(4500, StructureErrorCategory.NO_PERMISSION),
    EFFECTOR_EXECUTION_DENIED(4501, StructureErrorCategory.NO_PERMISSION),
    JOB_NOT_EXISTS(4603, StructureErrorCategory.NOT_FOUND),
    ITEM_NOT_EXISTS_OR_NOT_ACCESSIBLE(4700, StructureErrorCategory.NOT_FOUND),
    SUBSCRIPTION_NOT_EXISTS_OR_NOT_ACCESSIBLE(4800, StructureErrorCategory.NOT_FOUND),
    INVALID_FOREST_OPERATION(5002, StructureErrorCategory.INVALID_INPUT),
    UNSUPPORTED_FOREST_SOURCE_OPERATION(5003, StructureErrorCategory.INVALID_INPUT),
    UNAVAILABLE_MODULE(5004, StructureErrorCategory.GENERAL),
    MODULE_ERROR(5005, StructureErrorCategory.GENERAL),
    SIGNATURE_MISMATCH(5006, StructureErrorCategory.GENERAL),
    AUTOMATION_FAILED(5007, StructureErrorCategory.GENERAL),
    CONSISTENT_OPERATION_FAILED(5008, StructureErrorCategory.GENERAL),
    SAVED_COLUMN_NOT_EXISTS_OR_NOT_ACCESSIBLE(5101, StructureErrorCategory.NOT_FOUND),
    SAVED_COLUMN_MANAGEMENT_DENIED(5102, StructureErrorCategory.NO_PERMISSION),
    NOTE_NOT_EXISTS_OR_NOT_ACCESSIBLE(5201, StructureErrorCategory.NOT_FOUND),
    NOTE_EDIT_DENIED(5202, StructureErrorCategory.NO_PERMISSION);

    private final int myCode;
    private final StructureErrorCategory myCategory;

    private StructureErrors(int code, StructureErrorCategory category) {
        if (category == null) {
            throw new IllegalArgumentException("category must not be null");
        }
        this.myCode = code;
        this.myCategory = category;
    }

    @Override
    public int getCode() {
        return this.myCode;
    }

    @Override
    public StructureErrorCategory getCategory() {
        return this.myCategory;
    }

    public String toString() {
        return super.toString() + "[" + this.myCode + "]";
    }
}

