/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.effect;

import com.almworks.jira.structure.api.effect.StoredEffect;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.util.I18nText;
import com.almworks.jira.structure.api.util.JiraFunc;
import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.customfields.impl.GenericTextCFType;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.MultiGroupCFType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.customfields.impl.ProjectCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectConstant;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public final class CoreEffects {
    private CoreEffects() {
    }

    @NotNull
    public static StoredEffect emitWarning(@NotNull I18nText i18nText, @NotNull List<ItemIdentity> itemIdentities) {
        return StoredEffect.builder("com.almworks.jira.structure:warning-effect-provider").setParameter("i18nKey", i18nText.getI18nKey()).setParameter("arguments", Stream.of(i18nText.getArguments()).map(String::valueOf).collect(Collectors.toList())).setParameter("affectedItems", itemIdentities.stream().map(String::valueOf).collect(Collectors.toList())).build();
    }

    @NotNull
    public static StoredEffect assignIssue(@NotNull Issue issue, @Nullable ApplicationUser assignee) {
        return StoredEffect.builder("com.almworks.jira.structure:assignee-effect-provider").setParameter("issue", issue.getId()).setParameter("assignee", JiraFunc.USER_KEY.la(assignee)).build();
    }

    @NotNull
    public static StoredEffect setIssueReporter(@NotNull Issue issue, @Nullable ApplicationUser reporter) {
        return StoredEffect.builder("com.almworks.jira.structure:reporter-effect-provider").setParameter("issue", issue.getId()).setParameter("reporter", JiraFunc.USER_KEY.la(reporter)).build();
    }

    @NotNull
    public static StoredEffect setIssuePriority(@NotNull Issue issue, @Nullable Priority priority) {
        return StoredEffect.builder("com.almworks.jira.structure:priority-effect-provider").setParameter("issue", issue.getId()).setParameter("priority", JiraFunc.ISSUECONSTANT_ID.la((IssueConstant)priority)).build();
    }

    @NotNull
    public static StoredEffect setIssueDescription(@NotNull Issue issue, @Nullable String description) {
        return StoredEffect.builder("com.almworks.jira.structure:description-effect-provider").setParameter("issue", issue.getId()).setParameter("description", description).build();
    }

    @NotNull
    public static StoredEffect setIssueEnvironment(@NotNull Issue issue, @Nullable String environment) {
        return StoredEffect.builder("com.almworks.jira.structure:environment-effect-provider").setParameter("issue", issue.getId()).setParameter("environment", environment).build();
    }

    @NotNull
    public static StoredEffect setIssueResolution(@NotNull Issue issue, @Nullable Resolution resolution) {
        return StoredEffect.builder("com.almworks.jira.structure:resolution-effect-provider").setParameter("issue", issue.getId()).setParameter("resolution", JiraFunc.ISSUECONSTANT_ID.la((IssueConstant)resolution)).build();
    }

    @NotNull
    public static StoredEffect setIssueSummary(@NotNull Issue issue, @Nullable String summary) {
        return StoredEffect.builder("com.almworks.jira.structure:summary-effect-provider").setParameter("issue", issue.getId()).setParameter("summary", summary).build();
    }

    @NotNull
    public static StoredEffect setIssueDueDate(@NotNull Issue issue, @Nullable Date date) {
        return StoredEffect.builder("com.almworks.jira.structure:due-date-effect-provider").setParameter("issue", issue.getId()).setParameter("dueDate", date == null ? null : Long.valueOf(date.getTime())).build();
    }

    @Deprecated
    @NotNull
    public static StoredEffect setIssueResolutionDate(@NotNull Issue issue, @Nullable Date date) {
        return StoredEffect.builder("com.almworks.jira.structure:resolution-date-effect-provider").setParameter("issue", issue.getId()).setParameter("resolutionDate", date == null ? null : Long.valueOf(date.getTime())).build();
    }

    @NotNull
    public static StoredEffect setIssueStatus(@NotNull Issue issue, @Nullable Status status) {
        return StoredEffect.builder("com.almworks.jira.structure:status-effect-provider").setParameter("issue", issue.getId()).setParameter("status", JiraFunc.ISSUECONSTANT_ID.la((IssueConstant)status)).build();
    }

    @NotNull
    public static StoredEffect setOriginalEstimate(@NotNull Issue issue, @Nullable Long originalEstimate) {
        return StoredEffect.builder("com.almworks.jira.structure:original-estimate-effect-provider").setParameter("issue", issue.getId()).setParameter("originalEstimate", originalEstimate).build();
    }

    @NotNull
    public static StoredEffect setRemainingEstimate(@NotNull Issue issue, @Nullable Long remainingEstimate) {
        return StoredEffect.builder("com.almworks.jira.structure:remaining-estimate-effect-provider").setParameter("issue", issue.getId()).setParameter("remainingEstimate", remainingEstimate).build();
    }

    @NotNull
    public static StoredEffect setSprint(@NotNull Issue issue, @Nullable Long sprintId) {
        return StoredEffect.builder("com.almworks.jira.structure:sprint-effect-provider").setParameter("issue", issue.getId()).setParameter("to", sprintId).build();
    }

    @NotNull
    public static StoredEffect setSingleSelectCustomField(@NotNull Issue issue, @NotNull CustomField customField, @Nullable Option value) {
        CoreEffects.checkCustomFieldType(customField, SelectCFType.class);
        return StoredEffect.builder("com.almworks.jira.structure:single-select-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter("customField", customField.getId()).setParameter("value", JiraFunc.OPTION_ID.la(value)).build();
    }

    @NotNull
    public static StoredEffect setProjectPickerCustomField(@NotNull Issue issue, @NotNull CustomField customField, @Nullable Project value) {
        CoreEffects.checkCustomFieldType(customField, ProjectCFType.class);
        return StoredEffect.builder("com.almworks.jira.structure:project-picker-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter("customField", customField.getId()).setParameter("value", JiraFunc.PROJECT_ID.la(value)).build();
    }

    @NotNull
    public static StoredEffect setSingleUserCustomField(@NotNull Issue issue, @NotNull CustomField customField, @Nullable ApplicationUser value) {
        CoreEffects.checkCustomFieldType(customField, UserCFType.class);
        return StoredEffect.builder("com.almworks.jira.structure:single-user-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter("customField", customField.getId()).setParameter("value", JiraFunc.USER_KEY.la(value)).build();
    }

    @NotNull
    public static StoredEffect setSingleVersionCustomField(@NotNull Issue issue, @NotNull CustomField customField, @Nullable Version value) {
        CoreEffects.checkCustomFieldTypeIsMultiple(customField, VersionCFType.class, VersionCFType::isMultiple, false);
        return StoredEffect.builder("com.almworks.jira.structure:single-version-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter("customField", customField.getId()).setParameter("value", JiraFunc.PROJECTCONSTANT_ID.la((ProjectConstant)value)).build();
    }

    @NotNull
    public static StoredEffect setTextCustomField(@NotNull Issue issue, @NotNull CustomField customField, @Nullable String value) {
        CoreEffects.checkCustomFieldType(customField, GenericTextCFType.class);
        return StoredEffect.builder("com.almworks.jira.structure:text-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter("customField", customField.getId()).setParameter("value", value).build();
    }

    @NotNull
    public static StoredEffect setNumberCustomField(@NotNull Issue issue, @NotNull CustomField customField, @Nullable Number value) {
        CoreEffects.checkCustomFieldType(customField, NumberCFType.class);
        if (value instanceof BigInteger) {
            value = value.longValue();
        }
        if (value instanceof BigDecimal) {
            value = value.doubleValue();
        }
        return StoredEffect.builder("com.almworks.jira.structure:number-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter("customField", customField.getId()).setParameter("value", value).build();
    }

    @NotNull
    public static StoredEffect setDateCustomField(@NotNull Issue issue, @NotNull CustomField customField, @Nullable Date value) {
        CoreEffects.checkCustomFieldType(customField, DateCFType.class);
        return StoredEffect.builder("com.almworks.jira.structure:date-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter("customField", customField.getId()).setParameter("value", value == null ? null : Long.valueOf(value.getTime())).build();
    }

    @NotNull
    public static StoredEffect setDateTimeCustomField(@NotNull Issue issue, @NotNull CustomField customField, @Nullable Date value) {
        CoreEffects.checkCustomFieldType(customField, DateTimeCFType.class);
        return StoredEffect.builder("com.almworks.jira.structure:date-time-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter("customField", customField.getId()).setParameter("value", value == null ? null : Long.valueOf(value.getTime())).build();
    }

    @NotNull
    public static StoredEffect setSingleGroupCustomField(@NotNull Issue issue, @NotNull CustomField customField, @Nullable Group value) {
        CoreEffects.checkCustomFieldTypeIsMultiple(customField, MultiGroupCFType.class, MultiGroupCFType::isMultiple, false);
        return StoredEffect.builder("com.almworks.jira.structure:single-group-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter("customField", customField.getId()).setParameter("value", value == null ? null : value.getName()).build();
    }

    @NotNull
    public static StoredEffect setCascadeCustomField(@NotNull Issue issue, @NotNull CustomField customField, @Nullable Option value) {
        CoreEffects.checkCustomFieldType(customField, CascadingSelectCFType.class);
        return StoredEffect.builder("com.almworks.jira.structure:cascade-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter("customField", customField.getId()).setParameter("value", JiraFunc.OPTION_ID.la(value)).build();
    }

    public static StoredEffect setIssueLabels(Issue issue, Collection<String> labels) {
        return CoreEffects.updateLabels(issue, labels, "set");
    }

    public static StoredEffect addIssueLabels(Issue issue, Collection<String> labels) {
        return CoreEffects.updateLabels(issue, labels, "add");
    }

    public static StoredEffect removeIssueLabels(Issue issue, Collection<String> labels) {
        return CoreEffects.updateLabels(issue, labels, "remove");
    }

    @NotNull
    public static StoredEffect setIssueComponents(@NotNull Issue issue, @NotNull Collection<ProjectComponent> components) {
        return CoreEffects.updateComponents(issue, components, "set");
    }

    @NotNull
    public static StoredEffect addIssueComponents(@NotNull Issue issue, @NotNull Collection<ProjectComponent> components) {
        return CoreEffects.updateComponents(issue, components, "add");
    }

    @NotNull
    public static StoredEffect removeIssueComponents(@NotNull Issue issue, @NotNull Collection<ProjectComponent> components) {
        return CoreEffects.updateComponents(issue, components, "remove");
    }

    @NotNull
    public static StoredEffect setIssueAffectedVersions(@NotNull Issue issue, @NotNull Collection<Version> versions) {
        return CoreEffects.updateAffectedVersions(issue, versions, "set");
    }

    @NotNull
    public static StoredEffect addIssueAffectedVersions(@NotNull Issue issue, @NotNull Collection<Version> versions) {
        return CoreEffects.updateAffectedVersions(issue, versions, "add");
    }

    @NotNull
    public static StoredEffect removeIssueAffectedVersions(@NotNull Issue issue, @NotNull Collection<Version> versions) {
        return CoreEffects.updateAffectedVersions(issue, versions, "remove");
    }

    @NotNull
    public static StoredEffect setIssueFixVersions(@NotNull Issue issue, @NotNull Collection<Version> versions) {
        return CoreEffects.updateFixVersions(issue, versions, "set");
    }

    @NotNull
    public static StoredEffect addIssueFixVersions(@NotNull Issue issue, @NotNull Collection<Version> versions) {
        return CoreEffects.updateFixVersions(issue, versions, "add");
    }

    @NotNull
    public static StoredEffect removeIssueFixVersions(@NotNull Issue issue, @NotNull Collection<Version> versions) {
        return CoreEffects.updateFixVersions(issue, versions, "remove");
    }

    @NotNull
    public static StoredEffect setCustomFieldVersions(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Version> versions) {
        return CoreEffects.updateMultiVersionCustomField(issue, customField, versions, "set");
    }

    @NotNull
    public static StoredEffect addCustomFieldVersions(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Version> versions) {
        return CoreEffects.updateMultiVersionCustomField(issue, customField, versions, "add");
    }

    @NotNull
    public static StoredEffect removeCustomFieldVersions(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Version> versions) {
        return CoreEffects.updateMultiVersionCustomField(issue, customField, versions, "remove");
    }

    @NotNull
    public static StoredEffect setCustomFieldOptions(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Option> options) {
        return CoreEffects.updateMultiSelectCustomField(issue, customField, options, "set");
    }

    @NotNull
    public static StoredEffect addCustomFieldOptions(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Option> options) {
        return CoreEffects.updateMultiSelectCustomField(issue, customField, options, "add");
    }

    @NotNull
    public static StoredEffect removeCustomFieldOptions(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Option> options) {
        return CoreEffects.updateMultiSelectCustomField(issue, customField, options, "remove");
    }

    @NotNull
    public static StoredEffect setCustomFieldUsers(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<ApplicationUser> users) {
        return CoreEffects.updateMultiUserCustomField(issue, customField, users, "set");
    }

    @NotNull
    public static StoredEffect addCustomFieldUsers(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<ApplicationUser> users) {
        return CoreEffects.updateMultiUserCustomField(issue, customField, users, "add");
    }

    @NotNull
    public static StoredEffect removeCustomFieldUsers(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<ApplicationUser> users) {
        return CoreEffects.updateMultiUserCustomField(issue, customField, users, "remove");
    }

    @NotNull
    public static StoredEffect setCustomFieldGroups(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Group> groups) {
        return CoreEffects.updateMultiGroupCustomField(issue, customField, groups, "set");
    }

    @NotNull
    public static StoredEffect addCustomFieldGroups(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Group> groups) {
        return CoreEffects.updateMultiGroupCustomField(issue, customField, groups, "add");
    }

    @NotNull
    public static StoredEffect removeCustomFieldGroups(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Group> groups) {
        return CoreEffects.updateMultiGroupCustomField(issue, customField, groups, "remove");
    }

    @NotNull
    public static StoredEffect setCustomFieldLabels(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<String> labels) {
        return CoreEffects.updateLabelsCustomField(issue, customField, labels, "set");
    }

    @NotNull
    public static StoredEffect addCustomFieldLabels(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<String> labels) {
        return CoreEffects.updateLabelsCustomField(issue, customField, labels, "add");
    }

    @NotNull
    public static StoredEffect removeCustomFieldLabels(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<String> labels) {
        return CoreEffects.updateLabelsCustomField(issue, customField, labels, "remove");
    }

    @NotNull
    public static StoredEffect addIssueComment(@NotNull Issue issue, @Nullable String commentBody) {
        return StoredEffect.builder("com.almworks.jira.structure:add-comment-effect-provider").setParameter("issue", issue.getId()).setParameter("comment", commentBody).build();
    }

    @NotNull
    public static StoredEffect deleteIssueComment(@NotNull Issue issue, @NotNull Comment comment) {
        return StoredEffect.builder("com.almworks.jira.structure:delete-comment-effect-provider").setParameter("issue", issue.getId()).setParameter("comment", comment.getId()).build();
    }

    private static StoredEffect updateLabels(@NotNull Issue issue, @NotNull Collection<String> labels, @NotNull String operation) {
        return StoredEffect.builder("com.almworks.jira.structure:labels-effect-provider").setParameter("issue", issue.getId()).setParameter(operation, CoreEffects.unique(labels, String::trim)).build();
    }

    private static StoredEffect updateComponents(@NotNull Issue issue, @NotNull Collection<ProjectComponent> components, @NotNull String operation) {
        return StoredEffect.builder("com.almworks.jira.structure:components-effect-provider").setParameter("issue", issue.getId()).setParameter(operation, CoreEffects.unique(components, ProjectConstant::getId)).build();
    }

    private static StoredEffect updateAffectedVersions(@NotNull Issue issue, @NotNull Collection<Version> versions, @NotNull String operation) {
        return StoredEffect.builder("com.almworks.jira.structure:affects-versions-effect-provider").setParameter("issue", issue.getId()).setParameter(operation, CoreEffects.unique(versions, ProjectConstant::getId)).build();
    }

    private static StoredEffect updateFixVersions(@NotNull Issue issue, @NotNull Collection<Version> versions, @NotNull String operation) {
        return StoredEffect.builder("com.almworks.jira.structure:fix-versions-effect-provider").setParameter("issue", issue.getId()).setParameter(operation, CoreEffects.unique(versions, ProjectConstant::getId)).build();
    }

    private static StoredEffect updateMultiVersionCustomField(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Version> versions, @NotNull String operation) {
        CoreEffects.checkCustomFieldTypeIsMultiple(customField, VersionCFType.class, VersionCFType::isMultiple, true);
        return StoredEffect.builder("com.almworks.jira.structure:multi-versions-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter(operation, CoreEffects.unique(versions, ProjectConstant::getId)).setParameter("customField", customField.getId()).build();
    }

    private static StoredEffect updateMultiSelectCustomField(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Option> options, @NotNull String operation) {
        CoreEffects.checkCustomFieldType(customField, MultiSelectCFType.class);
        return StoredEffect.builder("com.almworks.jira.structure:multi-select-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter(operation, CoreEffects.unique(options, Option::getOptionId)).setParameter("customField", customField.getId()).build();
    }

    private static StoredEffect updateMultiUserCustomField(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<ApplicationUser> users, @NotNull String operation) {
        CoreEffects.checkCustomFieldType(customField, MultiUserCFType.class);
        return StoredEffect.builder("com.almworks.jira.structure:multi-user-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter(operation, CoreEffects.unique(users, ApplicationUser::getKey)).setParameter("customField", customField.getId()).build();
    }

    private static StoredEffect updateMultiGroupCustomField(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<Group> groups, @NotNull String operation) {
        CoreEffects.checkCustomFieldTypeIsMultiple(customField, MultiGroupCFType.class, MultiGroupCFType::isMultiple, true);
        return StoredEffect.builder("com.almworks.jira.structure:multi-group-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter(operation, CoreEffects.unique(groups, Group::getName)).setParameter("customField", customField.getId()).build();
    }

    private static StoredEffect updateLabelsCustomField(@NotNull Issue issue, @NotNull CustomField customField, @NotNull Collection<String> labels, @NotNull String operation) {
        CoreEffects.checkCustomFieldType(customField, LabelsCFType.class);
        return StoredEffect.builder("com.almworks.jira.structure:multi-labels-custom-field-effect-provider").setParameter("issue", issue.getId()).setParameter(operation, CoreEffects.unique(labels, String::trim)).setParameter("customField", customField.getId()).build();
    }

    @NotNull
    private static <T> List<Object> unique(@NotNull Collection<T> values, @NotNull Function<? super T, Object> serializer) {
        return values.stream().map(serializer).distinct().collect(Collectors.toList());
    }

    private static void checkCustomFieldType(@NotNull CustomField customField, @NotNull Class<? extends CustomFieldType> expectedType) throws IllegalArgumentException {
        CustomFieldType actualType = customField.getCustomFieldType();
        if (!expectedType.isInstance(actualType)) {
            throw new IllegalArgumentException(String.format("Expected a custom field of type %s, but %s \"%s\" is of type %s", expectedType, customField.getId(), customField.getName(), actualType));
        }
    }

    private static <T extends CustomFieldType> void checkCustomFieldTypeIsMultiple(@NotNull CustomField customField, @NotNull Class<T> customFieldType, @NotNull Function<T, Boolean> getter, boolean mustBeMultiple) {
        CoreEffects.checkCustomFieldType(customField, customFieldType);
        CustomFieldType cfType = customField.getCustomFieldType();
        if (getter.apply(cfType) != mustBeMultiple) {
            if (mustBeMultiple) {
                throw new IllegalArgumentException("Custom field must be multiple, but it's not: " + customField.getId());
            }
            throw new IllegalArgumentException("Custom field must not be multiple, but it is: " + customField.getId());
        }
    }
}

