/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.composition;

import com.almworks.jira.structure.api.attribute.loader.AggregateAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.DerivedAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.ItemAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.PropagateAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.ScanningAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.SingleRowAttributeLoader;
import org.jetbrains.annotations.NotNull;

public final class LoaderType
extends Enum<LoaderType> {
    public static final /* enum */ LoaderType PROPAGATE = new LoaderType(PropagateAttributeLoader.class, 4);
    public static final /* enum */ LoaderType AGGREGATE = new LoaderType(AggregateAttributeLoader.class, 4);
    public static final /* enum */ LoaderType SCANNING = new LoaderType(ScanningAttributeLoader.class, 4);
    public static final /* enum */ LoaderType SINGLE_ROW = new LoaderType(SingleRowAttributeLoader.class, 3);
    public static final /* enum */ LoaderType ITEM = new LoaderType(ItemAttributeLoader.class, 2);
    public static final /* enum */ LoaderType DERIVED = new LoaderType(DerivedAttributeLoader.class, 1);
    private final Class<? extends AttributeLoader> myLoaderClass;
    private final int myLoaderWeight;
    private static final /* synthetic */ LoaderType[] $VALUES;

    public static LoaderType[] values() {
        return (LoaderType[])$VALUES.clone();
    }

    public static LoaderType valueOf(String name) {
        return Enum.valueOf(LoaderType.class, name);
    }

    private LoaderType(Class<? extends AttributeLoader> loaderClass, int weight) {
        this.myLoaderClass = loaderClass;
        this.myLoaderWeight = weight;
    }

    public Class<? extends AttributeLoader> getLoaderClass() {
        return this.myLoaderClass;
    }

    public int getLoaderWeight() {
        return this.myLoaderWeight;
    }

    public boolean is(@NotNull AttributeLoader<?> loader) {
        return this.myLoaderClass.isInstance(loader);
    }

    public static LoaderType getType(@NotNull AttributeLoader<?> loader) {
        return LoaderType.getType(loader.getClass());
    }

    public static LoaderType getType(@NotNull Class<?> loaderClass) {
        for (LoaderType type : LoaderType.values()) {
            if (!type.getLoaderClass().isAssignableFrom(loaderClass)) continue;
            assert (LoaderType.getNumberOfTerminalInterfacesImplements(loaderClass) == 1) : loaderClass;
            return type;
        }
        throw new IllegalArgumentException("Unsupported AttributeLoader type: " + loaderClass);
    }

    private static int getNumberOfTerminalInterfacesImplements(@NotNull Class<?> loaderClass) {
        int interfacesNumber = 0;
        for (LoaderType type : LoaderType.values()) {
            if (!type.getLoaderClass().isAssignableFrom(loaderClass)) continue;
            ++interfacesNumber;
        }
        return interfacesNumber;
    }

    static {
        $VALUES = new LoaderType[]{PROPAGATE, AGGREGATE, SCANNING, SINGLE_ROW, ITEM, DERIVED};
    }
}

