package com.almworks.jira.structure.api.rest;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

@XmlRootElement
public final class RestValueRequest extends RestJobId {
  @XmlElement
  public List<ForestRowValueRequest> requests;

  @XmlRootElement
  public static class ForestRowValueRequest {
    /**
     * Spec of the forest for which the rows are loaded.
     */
    @XmlElement
    public RestForestSpec forestSpec;

    /**
     * Assumed ID of the forest. Resource bails if the ID is different. // todo implement
     */
    @XmlElement
    public long signature;

    /**
     * Rows requested
     */
    @XmlElement
    public List<Long> rows;

    /**
     * Attributes requested
     */
    @XmlElement
    public List<RestAttributeSpec> attributes;
  }
}
