package com.almworks.jira.structure.api.planningtask;

import com.almworks.jira.structure.api.error.StructureException;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

@Internal
public interface PlanningTaskUpdateBuilder {
  @NotNull
  PlanningTaskUpdateBuilder setSummary(@Nullable String summary);
  @NotNull
  PlanningTaskUpdateBuilder setDescription(@Nullable String description);
  @NotNull
  PlanningTaskUpdateBuilder setAssignee(@Nullable ApplicationUser user);
  @NotNull
  PlanningTaskUpdateBuilder setDueDate(@Nullable LocalDate date);
  @NotNull
  PlanningTaskUpdateBuilder setOriginalEstimate(@Nullable Long milliseconds);
  @NotNull
  PlanningTaskUpdateBuilder setRemainingEstimate(@Nullable Long milliseconds);
  @NotNull
  PlanningTaskUpdateBuilder setEnvironment(@Nullable String value);
  @NotNull
  PlanningTaskUpdateBuilder setReporter(@Nullable ApplicationUser value);
  @NotNull
  PlanningTaskUpdateBuilder setPriority(@Nullable Priority value);
  @NotNull
  PlanningTaskUpdateBuilder setIssueType(@NotNull IssueType value);
  @NotNull
  PlanningTaskUpdateBuilder setProject(@NotNull Project value);
  @NotNull
  PlanningTaskUpdateBuilder setLabels(@Nullable List<String> value);
  @NotNull
  PlanningTaskUpdateBuilder setAffectedVersions(@Nullable List<Version> value);
  @NotNull
  PlanningTaskUpdateBuilder setFixVersions(@Nullable List<Version> value);
  @NotNull
  PlanningTaskUpdateBuilder setComponents(@Nullable List<ProjectComponent> value);
  @NotNull
  PlanningTaskUpdateBuilder setTextCustomFieldValue(@Nullable String value, @NotNull CustomField customField);
  @NotNull
  PlanningTaskUpdateBuilder setDateTimeCustomFieldValue(@Nullable Date value, @NotNull CustomField customField);
  @NotNull
  PlanningTaskUpdateBuilder setNumberCustomFieldValue(@Nullable Double value, @NotNull CustomField customField);
  @NotNull
  PlanningTaskUpdateBuilder setDateCustomFieldValue(@Nullable LocalDate value, @NotNull CustomField customField);
  @NotNull
  PlanningTaskUpdateBuilder setLabelsCustomFieldValue(@Nullable List<String> value, @NotNull CustomField customField);
  @NotNull
  PlanningTaskUpdateBuilder setProjectCustomFieldValue(@Nullable Project value, @NotNull CustomField customField);
  @NotNull
  PlanningTaskUpdateBuilder setSingleVersionCustomFieldValue(@Nullable Version value, @NotNull CustomField customField);
  @NotNull
  PlanningTaskUpdateBuilder setMultiVersionCustomFieldValue(@Nullable List<Version> value, @NotNull CustomField customField);
  @NotNull
  PlanningTaskUpdateBuilder setSingleUserCustomFieldValue(@Nullable ApplicationUser value, @NotNull CustomField customField);

  void update() throws StructureException;
}
