package com.almworks.jira.structure.api.memo;

import com.almworks.jira.structure.api.error.StructureException;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.time.LocalDate;

@PublicApi
public interface MemoUpdateBuilder {
  @NotNull
  MemoUpdateBuilder setSummary(@Nullable String summary);
  @NotNull
  MemoUpdateBuilder setDescription(@Nullable String description);
  @NotNull
  MemoUpdateBuilder setAssignee(@Nullable ApplicationUser user);
  @NotNull
  MemoUpdateBuilder setDueDate(@Nullable LocalDate date);
  @NotNull
  MemoUpdateBuilder setOriginalEstimate(@Nullable Long milliseconds);
  @NotNull
  MemoUpdateBuilder setRemainingEstimate(@Nullable Long milliseconds);
  @NotNull
  MemoUpdateBuilder setTimeSpent(@Nullable Long milliseconds);
  void update() throws StructureException;
}
