package com.almworks.jira.structure.api.item;

import com.almworks.jira.structure.api.pull.DataVersion;
import com.almworks.jira.structure.api.pull.VersionedDataUpdate;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.Set;

public abstract class ItemVersionUpdate extends VersionedDataUpdate {
  protected ItemVersionUpdate(@NotNull DataVersion version) {
    super(version);
  }

  @NotNull
  public abstract DataVersion getFromVersion();

  @NotNull
  public abstract Set<ItemIdentity> getAffectedItems();


  public static final class Empty extends ItemVersionUpdate {
    public Empty(@NotNull DataVersion version) {
      super(version);
    }

    @NotNull
    public DataVersion getFromVersion() {
      return getVersion();
    }

    public boolean isEmpty() {
      return true;
    }

    @NotNull
    public Set<ItemIdentity> getAffectedItems() {
      return Collections.emptySet();
    }

    public String toString() {
      return String.format("empty[%s]", getVersion());
    }
  }


  public static final class Total extends ItemVersionUpdate {
    public Total(@NotNull DataVersion version) {
      super(version);
    }

    @NotNull
    public DataVersion getFromVersion() {
      return DataVersion.ZERO;
    }

    public boolean isFull() {
      return true;
    }

    @NotNull
    public Set<ItemIdentity> getAffectedItems() {
      return Collections.emptySet();
    }

    public String toString() {
      return String.format("FULL[%s]", getVersion());
    }
  }
}
