/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.sync.util;

import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.error.StructureError;
import com.almworks.jira.structure.api.error.StructureErrors;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.item.CoreIdentities;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.MissingRowException;
import com.almworks.jira.structure.api.row.RowManager;
import com.almworks.jira.structure.api.structure.StructureManager;
import com.almworks.jira.structure.api.sync.StructureSynchronizer;
import com.almworks.jira.structure.api.sync.SyncInstance;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.Issue;
import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import javax.annotation.concurrent.NotThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@NotThreadSafe
public class SyncLogger {
    private static final ThreadLocal<SyncLogger> SYNC_LOGGER_THREAD_LOCAL = new ThreadLocal();
    @Nullable
    private final SyncInstance mySync;
    private final StructureManager myStructureManager;
    private final RowManager myRowManager;
    private final boolean myAuto;
    private Logger myLogger;
    @NotNull
    private String myPrefix = "";
    private final Deque<Integer> myPrefixStack = new ArrayDeque<Integer>();

    public SyncLogger(Logger logger, @Nullable SyncInstance sync, StructureManager structureManager, RowManager rowManager, boolean auto) {
        this.myLogger = logger;
        this.mySync = sync;
        this.myStructureManager = structureManager;
        this.myRowManager = rowManager;
        this.myAuto = auto;
    }

    @NotNull
    public static SyncLogger get() {
        SyncLogger slog = SYNC_LOGGER_THREAD_LOCAL.get();
        if (slog == null) {
            throw new IllegalStateException("SyncLogger not installed - maybe not in synchronization thread?");
        }
        return slog;
    }

    @Internal
    public static void set(@Nullable SyncLogger syncLog) {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (!SyncLogger.class.getClassLoader().equals(threadClassLoader)) {
            throw new UnsupportedOperationException();
        }
        SYNC_LOGGER_THREAD_LOCAL.set(syncLog);
    }

    public static boolean isInfo() {
        return SyncLogger.get().getLogger().isInfoEnabled();
    }

    public static boolean isDebug() {
        return SyncLogger.get().getLogger().isDebugEnabled();
    }

    @NotNull
    public String getPrefix() {
        return this.myPrefix;
    }

    public void setPrefix(@NotNull String prefix) {
        this.myPrefix = prefix == null ? "" : prefix;
    }

    public void pushPrefix(@NotNull String prefixToAppend) {
        this.myPrefixStack.push(this.myPrefix.length());
        this.setPrefix(this.myPrefix + " " + prefixToAppend);
    }

    public void popPrefix() {
        this.myPrefix = this.myPrefix.substring(0, this.myPrefixStack.pop());
    }

    public Logger getLogger() {
        return this.myLogger;
    }

    public void setLogger(Logger logger) {
        this.myLogger = logger;
    }

    public boolean isOneTimeSync() {
        return this.mySync != null && this.mySync.getId() == 0L;
    }

    public boolean isAutoSync() {
        return this.myAuto;
    }

    public void info(Object ... msgs) {
        if (this.myLogger.isInfoEnabled()) {
            this.myLogger.info(this.createLogMessage(msgs));
        }
    }

    public void infoException(Throwable e, Object ... msgs) {
        if (this.myLogger.isInfoEnabled()) {
            this.myLogger.info(this.createLogMessage(msgs), e);
        }
    }

    public void debug(Object ... msgs) {
        if (this.myLogger.isDebugEnabled()) {
            this.myLogger.debug(this.createLogMessage(msgs));
        }
    }

    public void debugException(@Nullable Throwable ex, Object ... msgs) {
        if (this.myLogger.isDebugEnabled()) {
            if (ex != null) {
                this.myLogger.debug(this.createLogMessage(msgs), ex);
            } else {
                this.myLogger.debug(this.createLogMessage(msgs));
            }
        }
    }

    public void warn(Object ... msgs) {
        if (this.myLogger.isWarnEnabled()) {
            this.myLogger.warn(this.createLogMessage(msgs));
        }
    }

    public void warnException(@Nullable Throwable ex, Object ... msgs) {
        if (this.myLogger.isWarnEnabled()) {
            if (ex != null) {
                this.myLogger.warn(this.createLogMessage(msgs), ex);
            } else {
                this.myLogger.warn(this.createLogMessage(msgs));
            }
        }
    }

    public void warnExceptionIfDebug(@Nullable Throwable ex, Object ... msgs) {
        if (this.myLogger.isWarnEnabled()) {
            if (this.myLogger.isDebugEnabled()) {
                this.warnException(ex, msgs);
            } else if (ex != null) {
                this.warn(msgs, ex.getMessage());
            } else {
                this.warn(msgs);
            }
        }
    }

    public void error(Object ... msgs) {
        if (this.myLogger.isErrorEnabled()) {
            this.myLogger.error(this.createLogMessage(msgs));
        }
    }

    public void errorException(@Nullable Throwable e, Object ... msgs) {
        if (this.myLogger.isErrorEnabled()) {
            if (e != null) {
                this.myLogger.error(this.createLogMessage(msgs), e);
            } else {
                this.myLogger.error(this.createLogMessage(msgs));
            }
        }
    }

    public boolean isInfoEnabled() {
        return this.myLogger.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.myLogger.isDebugEnabled();
    }

    @NotNull
    public String createLogMessage(Object ... msgs) {
        StringBuilder msgBuilder = new StringBuilder(this.myPrefix);
        SyncLogger.appendLogMessages(msgBuilder, msgs);
        return msgBuilder.toString();
    }

    private static void appendLogMessages(StringBuilder sb, Object ... msgs) {
        if (msgs != null) {
            for (Object msg : msgs) {
                if (msg instanceof Object[]) {
                    SyncLogger.appendLogMessages(sb, (Object[])msg);
                    continue;
                }
                if (sb.length() > 0 && !SyncLogger.isNoSpaceBefore(msg)) {
                    sb.append(' ');
                }
                sb.append(msg);
            }
        }
    }

    private static boolean isNoSpaceBefore(Object msg) {
        char c = msg instanceof Character ? ((Character)msg).charValue() : (msg instanceof String && !((String)msg).isEmpty() ? ((String)msg).charAt(0) : (char)'\u0000');
        int type = Character.getType(c);
        return c != '\u0000' && (type == 24 || type == 15);
    }

    public final String defaultPrefix() {
        String syncLabel;
        if (this.mySync == null) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        StructureSynchronizer synchronizer = this.mySync.getSynchronizer();
        if (synchronizer != null) {
            syncLabel = synchronizer.getDescriptor().getLabel();
            if (syncLabel == null || syncLabel.isEmpty()) {
                syncLabel = synchronizer.getClass().getName();
            }
        } else {
            syncLabel = "<unavailable> " + this.mySync.getSynchronizerModuleKey();
        }
        long syncId = this.mySync.getId();
        boolean oneTime = this.isOneTimeSync();
        res.append(syncLabel).append(this.myAuto ? " autosync" : (oneTime ? " one-time sync" : " full sync"));
        if (!oneTime) {
            res.append(" #").append(syncId);
        }
        res.append(" for structure ");
        return StructureUtil.appendDebugStructureString(this.mySync.getStructureId(), this.myStructureManager, res).toString();
    }

    @NotNull
    public String username() {
        String userKey = this.mySync != null ? this.mySync.getUserKey() : StructureAuth.getUserKey();
        String userName = StructureUtil.getUserNameByKey(userKey);
        return userName == null ? "(null)" : userName;
    }

    @NotNull
    public String issue(Long issueId) {
        if (this.myLogger.isDebugEnabled()) {
            return StructureUtil.getDebugIssueString(issueId);
        }
        if (issueId == null) {
            return "null";
        }
        String s = StructureUtil.getDebugIssueKey(issueId);
        return s != null ? s : String.valueOf(issueId);
    }

    public StringBuilder appendIssue(Long issueId, StringBuilder sb) {
        if (this.myLogger.isDebugEnabled()) {
            return StructureUtil.appendDebugIssueString(issueId, StructureUtil.getDebugIssueKey(issueId), sb);
        }
        if (issueId == null) {
            return sb.append("null");
        }
        String s = StructureUtil.getDebugIssueKey(issueId);
        return sb.append(s != null ? s : String.valueOf(issueId));
    }

    @NotNull
    public String issue(@Nullable Issue issue) {
        if (this.myLogger.isDebugEnabled()) {
            return StructureUtil.getDebugIssueString(issue);
        }
        if (issue == null) {
            return "null";
        }
        String s = issue.getKey();
        return s != null ? s : "#" + issue.getId();
    }

    @NotNull
    public String issues(@Nullable Iterable<? extends Issue> issues) {
        if (issues == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("[");
        Iterator sep = Iterators.concat((Iterator)Iterators.singletonIterator((Object)""), (Iterator)Iterators.cycle((Object[])new String[]{", "}));
        for (Issue issue : issues) {
            sb.append((String)sep.next()).append(this.issue(issue));
        }
        return sb.append("]").toString();
    }

    public String issues(@Nullable LongIterable issues) {
        if (issues == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("[");
        Iterator sep = Iterators.concat((Iterator)Iterators.singletonIterator((Object)""), (Iterator)Iterators.cycle((Object[])new String[]{", "}));
        for (LongIterator issueIt : issues) {
            this.appendIssue(issueIt.value(), sb.append((String)sep.next()));
        }
        return sb.append("]").toString();
    }

    @NotNull
    public String structure(long structureId) {
        return StructureUtil.getDebugStructureString(structureId, this.myStructureManager);
    }

    public Object selectBySyncMode(Object ifAuto, Object ifResync, Object ifOneTime) {
        return this.myAuto ? ifAuto : (this.isOneTimeSync() ? ifOneTime : ifResync);
    }

    public StringBuilder appendForest(Forest forest, StringBuilder sb) {
        int size = forest.size();
        for (int i = 0; i < size; ++i) {
            long rowId = forest.getRow(i);
            if (i > 0) {
                sb.append(',');
            }
            sb.append(rowId).append(':').append(forest.getDepth(i)).append(':');
            this.appendItem(rowId, sb);
        }
        return sb;
    }

    public String forest(Forest forest) {
        return this.appendForest(forest, new StringBuilder()).toString();
    }

    public StringBuilder appendItemForest(ItemForest itemForest, StringBuilder sb) {
        Forest forest = itemForest.getForest();
        int size = forest.size();
        for (int i = 0; i < size; ++i) {
            long rowId = forest.getRow(i);
            if (i > 0) {
                sb.append(',');
            }
            sb.append(rowId).append(':').append(forest.getDepth(i)).append(':');
            try {
                this.appendItem(itemForest.getRow(rowId).getItemId(), sb);
                continue;
            }
            catch (MissingRowException e) {
                sb.append("<missing row ").append(rowId).append('>');
            }
        }
        return sb;
    }

    public String itemForest(ItemForest itemForest) {
        return this.appendItemForest(itemForest, new StringBuilder()).toString();
    }

    public StringBuilder appendRows(LongIterable rowIds, StringBuilder sb) {
        boolean appendComma = false;
        for (LongIterator rowIdIt : rowIds) {
            long rowId = rowIdIt.value();
            if (appendComma) {
                sb.append(',');
            } else {
                appendComma = true;
            }
            sb.append(rowId).append(':');
            this.appendItem(rowId, sb);
        }
        return sb;
    }

    public StringBuilder appendItem(long rowId, StringBuilder sb) {
        try {
            return this.appendItem(this.myRowManager.getRow(rowId).getItemId(), sb);
        }
        catch (MissingRowException e) {
            return sb.append("<missing row ").append(rowId).append('>');
        }
    }

    public StringBuilder appendItem(ItemIdentity itemId, StringBuilder sb) {
        if (CoreIdentities.isIssue(itemId)) {
            return this.appendIssue(itemId.getLongId(), sb);
        }
        sb.append(itemId.getItemType()).append("/");
        if (itemId.isLongId()) {
            sb.append(itemId.getLongId());
        } else {
            sb.append(itemId.getStringId());
        }
        return sb;
    }

    public String row(long rowId) {
        if (rowId == 0L) {
            return "0";
        }
        if (rowId < 0L) {
            return "r" + rowId;
        }
        try {
            ItemIdentity itemId = this.myRowManager.getRow(rowId).getItemId();
            StringBuilder sb = new StringBuilder();
            this.appendItem(itemId, sb);
            sb.append(" (row ").append(rowId).append(')');
            return sb.toString();
        }
        catch (MissingRowException e) {
            return "<missing row " + rowId + '>';
        }
    }

    public String rows(LongIterable rowIds) {
        return this.appendRows(rowIds, new StringBuilder()).toString();
    }

    @Nullable
    public String warnStructureException(StructureException e) {
        StructureError error = e.getError();
        if (error == StructureErrors.STRUCTURE_NOT_EXISTS_OR_NOT_ACCESSIBLE) {
            return this.warnAndReturn("cannot run because the structure does not exist or is not accessible for user", this.username());
        }
        if (error == StructureErrors.FOREST_CHANGE_PROHIBITED_BY_PARENT_PERMISSIONS) {
            return this.warnAndReturn("Error while synchronizing", this.row(e.getRow()), ":", e.getProblemDetails());
        }
        if (error == StructureErrors.STRUCTURE_EDIT_DENIED) {
            return this.warnAndReturn("cannot run under user", this.username(), "because he or she does not have permissions to edit the structure");
        }
        if (error == StructureErrors.STRUCTURE_PLUGIN_ACCESS_DENIED) {
            return this.warnAndReturn("cannot run under", this.username(), Character.valueOf(':'), "Structure plugin is not enabled for this user");
        }
        this.warnExceptionIfDebug(e, "encountered a problem");
        return null;
    }

    private String warnAndReturn(Object ... msgs) {
        String message = this.createLogMessage(msgs);
        this.warn(message);
        return message;
    }
}

