/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.folder;

import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.PublicApi;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public final class Folder {
    @NotNull
    private final String myName;
    @Nullable
    private final Long myOwningStructure;

    private Folder(@NotNull String name, @Nullable Long owningStructure) {
        this.myName = StructureUtil.nonBlank(name);
        this.myOwningStructure = owningStructure;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public Long getOwningStructure() {
        return this.myOwningStructure;
    }

    @NotNull
    public static Builder named(@NotNull String name) {
        return new Builder(name);
    }

    @NotNull
    public static Builder copy(@NotNull Folder folder) {
        return new Builder(folder.getName()).setOwningStructure(folder.getOwningStructure());
    }

    @PublicApi
    public static final class Builder {
        @NotNull
        private String myName;
        @Nullable
        private Long myOwningStructure;

        private Builder(@NotNull String name) {
            this.myName = this.checkName(name);
        }

        @NotNull
        public Builder setName(@NotNull String name) {
            this.myName = this.checkName(name);
            return this;
        }

        private String checkName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("Folder name must not be blank.");
            }
            return StringUtils.abbreviate((String)name, (int)190);
        }

        @NotNull
        public Builder setOwningStructure(@Nullable Long owningStructure) {
            this.myOwningStructure = owningStructure;
            return this;
        }

        @NotNull
        public Folder build() {
            return new Folder(this.myName, this.myOwningStructure);
        }
    }
}

