package com.almworks.jira.structure.api.attribute.loader.delegate;

import com.almworks.integers.LongSet;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.RowAttributeLoader;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import org.jetbrains.annotations.NotNull;

public abstract class DelegatingRowAttributeLoader<T, L extends RowAttributeLoader<T>> extends DelegatingAttributeLoader<T, L> implements RowAttributeLoader<T> {
  protected DelegatingRowAttributeLoader(@NotNull L loader) {
    super(loader);
  }

  @Override
  public void preload(@NotNull LongSet rowIds, @NotNull ItemForest forest, @NotNull AttributeContext context) {
    delegate().preload(rowIds, forest, context);
  }

  @Override
  public boolean isWholeForestDependent() {
    return delegate().isWholeForestDependent();
  }
}
