/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.reduce;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.AggregateAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.basic.AbstractAggregateLoader;
import com.almworks.jira.structure.api.attribute.loader.reduce.ReductionStrategy;
import com.almworks.jira.structure.api.attribute.loader.reduce.ValueReducer;
import com.almworks.jira.structure.api.item.CoreIdentities;
import com.almworks.jira.structure.api.row.StructureRow;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public abstract class ReducingAggregateLoader<T>
extends AbstractAggregateLoader<T>
implements ValueReducer<T> {
    private final ReductionStrategy<T> myReductionStrategy;

    public ReducingAggregateLoader(AttributeSpec<T> spec) {
        super(spec);
        this.myReductionStrategy = ReductionStrategy.forAttributeSpec(spec);
    }

    @Override
    public AttributeValue<T> loadValue(List<AttributeValue<T>> childrenValues, AggregateAttributeContext context) {
        AttributeValue<T> error;
        List<StructureRow> children = context.getChildren();
        if (children.stream().anyMatch(row -> CoreIdentities.isAutomation(row.getItemId()))) {
            assert (children.size() == childrenValues.size());
            childrenValues = IntStream.range(0, children.size()).filter(idx -> !CoreIdentities.isAutomation(((StructureRow)children.get(idx)).getItemId())).mapToObj(childrenValues::get).collect(Collectors.toList());
        }
        if ((error = ReducingAggregateLoader.firstChildError(childrenValues)) != null) {
            return error;
        }
        return this.myReductionStrategy.apply(() -> this.getSelfValue(context), childrenValues, this);
    }

    @NotNull
    protected abstract AttributeValue<T> getSelfValue(AggregateAttributeContext var1);
}

