/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeContextDependency;
import com.almworks.jira.structure.api.attribute.loader.ItemAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.ItemAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.builder.ArbitraryDependenciesAttributeLoaderBuilder;
import com.almworks.jira.structure.api.attribute.loader.builder.AttributeLoaderBuilder;
import com.almworks.jira.structure.api.attribute.loader.builder.BaseItemAttributeLoader;
import com.almworks.jira.structure.api.item.ItemIdentity;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class ItemAttributeLoaderBuilder<T, I>
extends ArbitraryDependenciesAttributeLoaderBuilder<T, ItemAttributeLoaderBuilder<T, I>> {
    private AbstractLoadingStrategy<T, I> myLoadingStrategy;
    private Predicate<String> myItemTypeSupportedPredicate;
    private Class<I> myItemClass;
    private Function<I, ItemIdentity> myItemTrailFunction;
    private Function<T, ItemIdentity> myValueBasedTrailFunction;
    private Boolean myYieldOnNull;
    private BiConsumer<Collection<ItemIdentity>, AttributeContext> myPreloadFunction;

    public ItemAttributeLoaderBuilder<T, I> valueFunctionIIAV(BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> loadingFunction) {
        this.myLoadingStrategy = new SimpleLoadStrategy(loadingFunction);
        return this;
    }

    public ItemAttributeLoaderBuilder<T, I> valueFunctionIIAV(Function<ItemIdentity, AttributeValue<T>> valueFunction) {
        return this.valueFunctionIIAV((ItemIdentity item, ItemAttributeContext ctx) -> (AttributeValue)valueFunction.apply((ItemIdentity)item));
    }

    public ItemAttributeLoaderBuilder<T, I> valueFunctionAV(BiFunction<? super I, ItemAttributeContext, AttributeValue<T>> itemLoadingFunction) {
        this.myLoadingStrategy = new ResolveAndLoadStrategy<T, I>(itemLoadingFunction);
        return this;
    }

    public ItemAttributeLoaderBuilder<T, I> valueFunctionAV(Function<? super I, AttributeValue<T>> itemFunction) {
        return this.valueFunctionAV((? super I item, ItemAttributeContext ctx) -> (AttributeValue)itemFunction.apply((Object)item));
    }

    public ItemAttributeLoaderBuilder<T, I> valueFunctionII(BiFunction<ItemIdentity, ItemAttributeContext, ? extends T> valueFunction) {
        this.myLoadingStrategy = new LoadAndHandleStrategy<T, I>(valueFunction);
        return (ItemAttributeLoaderBuilder)this.self();
    }

    public ItemAttributeLoaderBuilder<T, I> valueFunctionII(Function<ItemIdentity, ? extends T> valueFunction) {
        return this.valueFunctionII((ItemIdentity item, ItemAttributeContext ctx) -> valueFunction.apply((ItemIdentity)item));
    }

    public ItemAttributeLoaderBuilder<T, I> valueFunction(BiFunction<? super I, ItemAttributeContext, ? extends T> itemFunction) {
        this.myLoadingStrategy = new ResolveAndLoadAndHandleStrategy<T, I>(itemFunction);
        return (ItemAttributeLoaderBuilder)this.self();
    }

    public ItemAttributeLoaderBuilder<T, I> valueFunction(Function<? super I, ? extends T> itemFunction) {
        return this.valueFunction((? super I item, ItemAttributeContext ctx) -> itemFunction.apply((Object)item));
    }

    public <C> ItemAttributeLoaderBuilder<T, C> itemClass(Class<C> itemClass) {
        ItemAttributeLoaderBuilder r = this;
        r.myItemClass = ItemAttributeLoaderBuilder.notNull(itemClass, "itemClass");
        return r;
    }

    public ItemAttributeLoaderBuilder<T, I> itemType(String ... itemTypes) {
        if (itemTypes.length == 0) {
            throw new IllegalArgumentException("need at least one item type");
        }
        HashSet<String> acceptableTypes = new HashSet<String>(itemTypes.length);
        for (String itemType : itemTypes) {
            if (itemType == null) {
                throw new IllegalArgumentException("itemType cannot be null");
            }
            acceptableTypes.add(itemType);
        }
        if (acceptableTypes.size() == 1) {
            String itemType = (String)acceptableTypes.iterator().next();
            this.myItemTypeSupportedPredicate = itemType::equals;
        } else {
            this.myItemTypeSupportedPredicate = acceptableTypes::contains;
        }
        return this;
    }

    public ItemAttributeLoaderBuilder<T, I> anyItemType() {
        this.myItemTypeSupportedPredicate = null;
        return this;
    }

    public ItemAttributeLoaderBuilder<T, I> itemTrail(Function<I, ItemIdentity> itemTrailFunction) {
        this.myItemTrailFunction = itemTrailFunction;
        if (itemTrailFunction != null) {
            this.contextDependency(AttributeContextDependency.TRAIL);
        }
        return (ItemAttributeLoaderBuilder)this.self();
    }

    public ItemAttributeLoaderBuilder<T, I> valueTrail(Function<T, ItemIdentity> valueBasedTrailFunction) {
        this.myValueBasedTrailFunction = valueBasedTrailFunction;
        if (valueBasedTrailFunction != null) {
            this.contextDependency(AttributeContextDependency.TRAIL);
        }
        return (ItemAttributeLoaderBuilder)this.self();
    }

    public ItemAttributeLoaderBuilder<T, I> yieldOnNull() {
        this.myYieldOnNull = true;
        return (ItemAttributeLoaderBuilder)this.self();
    }

    public ItemAttributeLoaderBuilder<T, I> preload(BiConsumer<Collection<ItemIdentity>, AttributeContext> preloadFunction) {
        this.myPreloadFunction = preloadFunction;
        return (ItemAttributeLoaderBuilder)this.self();
    }

    public ItemAttributeLoader<T> build() {
        AbstractLoadingStrategy<T, I> strategy = ItemAttributeLoaderBuilder.notNull(this.myLoadingStrategy, "loading function");
        if (this.myItemClass != null) {
            strategy.setItemClass(this.myItemClass);
        }
        if (this.myYieldOnNull != null) {
            strategy.setYieldOnNull(this.myYieldOnNull);
        }
        if (this.myValueBasedTrailFunction != null) {
            strategy.setValueBasedTrailFunction(this.myValueBasedTrailFunction);
        }
        if (this.myItemTrailFunction != null) {
            strategy.setItemTrailFunction(this.myItemTrailFunction);
        }
        return new BaseItemAttributeLoader<T>(ItemAttributeLoaderBuilder.notNull(this.myAttributeSpec, "attributeSpec"), ItemAttributeLoaderBuilder.nullableCollectionOfNonNulls(this.buildDependencies(), "dependencies"), ItemAttributeLoaderBuilder.nullableCollectionOfNonNulls(this.buildContextDependencies(), "contextDependencies"), this.myCachingStrategy, this.myGlobalTrail, this.myItemTypeSupportedPredicate, strategy.createLoadingFunction(), this.myPreloadFunction);
    }

    private static <I> void applyItemTrailFunction(I item, Function<I, ItemIdentity> itemTrailFunction, ItemAttributeContext ctx) {
        ItemIdentity trail;
        if (itemTrailFunction != null && (trail = itemTrailFunction.apply(item)) != null) {
            ctx.addTrail(trail);
        }
    }

    @Nullable
    private static <T> AttributeValue<T> handleValue(T value, boolean yieldOnNull, Function<? super T, ItemIdentity> valueBasedTrailFunction, ItemAttributeContext context) {
        ItemIdentity trailItem;
        if (value == null && yieldOnNull) {
            return null;
        }
        if (value != null && valueBasedTrailFunction != null && (trailItem = valueBasedTrailFunction.apply(value)) != null) {
            context.addTrail(trailItem);
        }
        return AttributeValue.ofNullable(value);
    }

    private static class ResolveAndLoadAndHandle<T, I>
    implements BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> {
        private final boolean myYieldOnNull;
        private final Function<? super T, ItemIdentity> myValueBasedTrailFunction;
        private final BiFunction<? super I, ItemAttributeContext, ? extends T> myItemFunction;
        private final Class<I> myItemClass;
        private final Function<I, ItemIdentity> myItemTrailFunction;

        ResolveAndLoadAndHandle(BiFunction<? super I, ItemAttributeContext, ? extends T> itemFunction, boolean yieldOnNull, Function<? super T, ItemIdentity> valueBasedTrailFunction, Class<I> itemClass, Function<I, ItemIdentity> itemTrailFunction) {
            this.myItemFunction = itemFunction;
            this.myYieldOnNull = yieldOnNull;
            this.myValueBasedTrailFunction = valueBasedTrailFunction;
            this.myItemClass = itemClass;
            this.myItemTrailFunction = itemTrailFunction;
        }

        @Override
        public AttributeValue<T> apply(ItemIdentity itemId, ItemAttributeContext context) {
            I item = context.getItem(this.myItemClass);
            if (item == null) {
                return AttributeValue.undefined();
            }
            ItemAttributeLoaderBuilder.applyItemTrailFunction(item, this.myItemTrailFunction, context);
            T value = this.myItemFunction.apply(item, context);
            return ItemAttributeLoaderBuilder.handleValue(value, this.myYieldOnNull, this.myValueBasedTrailFunction, context);
        }
    }

    private static class ResolveAndLoadAndHandleStrategy<T, I>
    extends HandleStrategy<T, I> {
        private BiFunction<? super I, ItemAttributeContext, ? extends T> myItemFunction;
        private Class<I> myItemClass;
        private Function<I, ItemIdentity> myItemTrailFunction;

        ResolveAndLoadAndHandleStrategy(BiFunction<? super I, ItemAttributeContext, ? extends T> itemFunction) {
            this.myItemFunction = itemFunction;
        }

        @Override
        public void setItemClass(Class<I> itemClass) {
            this.myItemClass = itemClass;
        }

        @Override
        public void setItemTrailFunction(Function<I, ItemIdentity> itemTrailFunction) {
            this.myItemTrailFunction = itemTrailFunction;
        }

        @Override
        BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> createLoadingFunction() {
            return new ResolveAndLoadAndHandle<T, I>(AttributeLoaderBuilder.notNull(this.myItemFunction, "itemFunction"), this.myYieldOnNull, this.myValueBasedTrailFunction, AttributeLoaderBuilder.notNull(this.myItemClass, "itemClass"), this.myItemTrailFunction);
        }
    }

    private static class LoadAndHandle<T>
    implements BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> {
        private final boolean myYieldOnNull;
        private final Function<? super T, ItemIdentity> myValueBasedTrailFunction;
        private final BiFunction<ItemIdentity, ItemAttributeContext, ? extends T> myValueFunction;

        LoadAndHandle(BiFunction<ItemIdentity, ItemAttributeContext, ? extends T> valueFunction, boolean yieldOnNull, Function<? super T, ItemIdentity> valueBasedTrailFunction) {
            this.myValueFunction = valueFunction;
            this.myYieldOnNull = yieldOnNull;
            this.myValueBasedTrailFunction = valueBasedTrailFunction;
        }

        @Override
        public AttributeValue<T> apply(ItemIdentity itemId, ItemAttributeContext context) {
            T value = this.myValueFunction.apply(itemId, context);
            return ItemAttributeLoaderBuilder.handleValue(value, this.myYieldOnNull, this.myValueBasedTrailFunction, context);
        }
    }

    private static class LoadAndHandleStrategy<T, I>
    extends HandleStrategy<T, I> {
        private BiFunction<ItemIdentity, ItemAttributeContext, ? extends T> myValueFunction;

        LoadAndHandleStrategy(BiFunction<ItemIdentity, ItemAttributeContext, ? extends T> valueFunction) {
            this.myValueFunction = valueFunction;
        }

        @Override
        BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> createLoadingFunction() {
            return new LoadAndHandle<T>(AttributeLoaderBuilder.notNull(this.myValueFunction, "valueFunction"), this.myYieldOnNull, this.myValueBasedTrailFunction);
        }
    }

    private static abstract class HandleStrategy<T, I>
    extends AbstractLoadingStrategy<T, I> {
        protected boolean myYieldOnNull;
        protected Function<? super T, ItemIdentity> myValueBasedTrailFunction;

        private HandleStrategy() {
        }

        @Override
        public void setYieldOnNull(boolean yieldOnNull) {
            this.myYieldOnNull = yieldOnNull;
        }

        @Override
        public void setValueBasedTrailFunction(Function<? super T, ItemIdentity> valueBasedTrailFunction) {
            this.myValueBasedTrailFunction = valueBasedTrailFunction;
        }
    }

    private static class ResolveAndLoad<T, I>
    implements BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> {
        private final Class<I> myItemClass;
        private final BiFunction<? super I, ItemAttributeContext, AttributeValue<T>> myItemLoadingFunction;
        private final Function<I, ItemIdentity> myItemTrailFunction;

        ResolveAndLoad(Class<I> itemClass, BiFunction<? super I, ItemAttributeContext, AttributeValue<T>> itemLoadingFunction, Function<I, ItemIdentity> itemTrailFunction) {
            this.myItemClass = itemClass;
            this.myItemLoadingFunction = itemLoadingFunction;
            this.myItemTrailFunction = itemTrailFunction;
        }

        @Override
        public AttributeValue<T> apply(ItemIdentity itemId, ItemAttributeContext ctx) {
            I item = ctx.getItem(this.myItemClass);
            if (item == null) {
                return AttributeValue.undefined();
            }
            ItemAttributeLoaderBuilder.applyItemTrailFunction(item, this.myItemTrailFunction, ctx);
            return this.myItemLoadingFunction.apply(item, ctx);
        }
    }

    private static class ResolveAndLoadStrategy<T, I>
    extends AbstractLoadingStrategy<T, I> {
        private BiFunction<? super I, ItemAttributeContext, AttributeValue<T>> myItemLoadingFunction;
        private Class<I> myItemClass;
        private Function<I, ItemIdentity> myItemTrailFunction;

        ResolveAndLoadStrategy(BiFunction<? super I, ItemAttributeContext, AttributeValue<T>> itemLoadingFunction) {
            this.myItemLoadingFunction = AttributeLoaderBuilder.notNull(itemLoadingFunction, "itemLoadingFunction");
        }

        @Override
        public void setItemClass(Class<I> itemClass) {
            this.myItemClass = itemClass;
        }

        @Override
        public void setItemTrailFunction(Function<I, ItemIdentity> itemTrailFunction) {
            this.myItemTrailFunction = itemTrailFunction;
        }

        @Override
        BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> createLoadingFunction() {
            return new ResolveAndLoad<T, I>(AttributeLoaderBuilder.notNull(this.myItemClass, "itemClass"), this.myItemLoadingFunction, this.myItemTrailFunction);
        }
    }

    private static class SimpleLoadStrategy<T, I>
    extends AbstractLoadingStrategy<T, I> {
        private final BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> myLoadingFunction;

        SimpleLoadStrategy(BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> loadingFunction) {
            this.myLoadingFunction = AttributeLoaderBuilder.notNull(loadingFunction, "loadingFunction");
        }

        @Override
        BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> createLoadingFunction() {
            return this.myLoadingFunction;
        }
    }

    private static abstract class AbstractLoadingStrategy<T, I> {
        private AbstractLoadingStrategy() {
        }

        abstract BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> createLoadingFunction();

        public void setValueBasedTrailFunction(Function<? super T, ItemIdentity> valueBasedTrailFunction) {
            throw new IllegalArgumentException(this.getClass() + " does not accept valueBasedTrailFunction");
        }

        public void setYieldOnNull(boolean yieldOnNull) {
            throw new IllegalArgumentException(this.getClass() + " does not accept yieldOnNull");
        }

        public void setItemClass(Class<I> itemClass) {
            throw new IllegalArgumentException(this.getClass() + " does not accept typed");
        }

        public void setItemTrailFunction(Function<I, ItemIdentity> itemTrailFunction) {
            throw new IllegalArgumentException(this.getClass() + " does not accept itemTrailFunction");
        }
    }
}

