package com.almworks.jira.structure.api.item;

import com.almworks.jira.structure.api.error.StructureRuntimeException;

/**
 * This exception is thrown if the application code expects an Item Type with a specific ID to be present, but it
 * isn't registered in the system.
 */
public class ItemTypeNotFoundException extends StructureRuntimeException {
  public ItemTypeNotFoundException(int id) {
    super("item type " + id + " was not found");
  }
}
