package com.almworks.jira.structure.api.effector;

import com.almworks.jira.structure.api.effect.StoredEffect;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

/**
 * An output sink for an {@link Effector effector}, where it puts its
 * {@link StoredEffect effect descriptions}.
 */
@PublicApi
public interface EffectCollector {
  /**
   * Adds a new effect description to the effector output.
   */
  void addEffect(@NotNull StoredEffect effect);
}
