/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.row;

import com.almworks.integers.LongList;
import com.almworks.integers.wrappers.LongLongHppcOpenHashMap;
import com.almworks.jira.structure.api.attribute.ValueColumn;
import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public interface RowMapper {
    public long mapRow(long var1);

    public Mapping map(LongList var1);

    public static class Mapping {
        private final LongList myRequestedRows;
        private final LongList myMappedRows;
        private final LongLongHppcOpenHashMap myMap;

        private Mapping(LongList requestedRows, LongList mappedRows, LongLongHppcOpenHashMap map) {
            this.myRequestedRows = requestedRows;
            this.myMappedRows = mappedRows;
            this.myMap = map;
        }

        public static Mapping identical(LongList rows) {
            return new Mapping(rows, rows, null);
        }

        public static Mapping mapped(LongList rows, LongList mappedRows, LongLongHppcOpenHashMap map) {
            return new Mapping(rows, mappedRows, map);
        }

        public LongList getRequestedRows() {
            return this.myRequestedRows;
        }

        public LongList getMappedRows() {
            return this.myMappedRows;
        }

        @Nullable
        public LongLongHppcOpenHashMap getMap() {
            return this.myMap;
        }

        public boolean isMapped() {
            return this.myMap != null;
        }

        @NotNull
        public <T> ValueColumn<Long, T> createMappedResultColumn(@Nullable ValueColumn<Long, T> actualColumn) {
            if (actualColumn == null) {
                return ValueColumn.empty();
            }
            if (this.myMap == null) {
                return actualColumn;
            }
            return row -> {
                if (row == null) {
                    row = 0L;
                }
                long mapped = this.myMap.containsKey(row.longValue()) ? this.myMap.lget() : row.longValue();
                return actualColumn.getValue(mapped);
            };
        }
    }
}

