/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.pull;

import com.atlassian.annotations.PublicApi;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.Nullable;

@PublicApi
@Immutable
public class DataVersion {
    public static final DataVersion ZERO = new DataVersion(0, 0);
    private final int mySignature;
    private final int myVersion;

    public DataVersion(int signature, int version) {
        this.mySignature = signature;
        this.myVersion = version;
    }

    public boolean isComparable(@Nullable DataVersion anotherVersion) {
        return anotherVersion != null && this.mySignature == anotherVersion.getSignature();
    }

    public boolean isBefore(@Nullable DataVersion anotherVersion) {
        if (!this.isComparable(anotherVersion)) {
            assert (false) : this + " vs. " + anotherVersion;
            return false;
        }
        assert (anotherVersion != null) : this;
        return this.myVersion < anotherVersion.getVersion();
    }

    public DataVersion increment() {
        return this.increment(1);
    }

    public DataVersion increment(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("version cannot decrement");
        }
        if (count == 0) {
            return this;
        }
        return new DataVersion(this.mySignature, this.myVersion + count);
    }

    public int getSignature() {
        return this.mySignature;
    }

    public int getVersion() {
        return this.myVersion;
    }

    public String toString() {
        return String.format("%08x:%d", this.mySignature, this.myVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataVersion that = (DataVersion)o;
        if (this.mySignature != that.mySignature) {
            return false;
        }
        return this.myVersion == that.myVersion;
    }

    public int hashCode() {
        int result = this.mySignature;
        result = 31 * result + this.myVersion;
        return result;
    }
}

