/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.job;

import com.almworks.jira.structure.api.job.StructureJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStructureJob
implements StructureJob {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStructureJob.class);
    protected final Object myLock = new Object();
    private StructureJob.State myState = StructureJob.State.PENDING;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final StructureJob.State getState() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + (Object)((Object)this.myState) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(StructureJob.State oldState, StructureJob.State state) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == oldState) {
                this.myState = state;
            } else {
                logger.warn(this + ": state inconsistency, expected " + (Object)((Object)oldState) + " actual " + (Object)((Object)this.myState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == StructureJob.State.RUNNING) {
                logger.warn("resetting state of a running job " + this);
            }
            this.myState = StructureJob.State.PENDING;
        }
    }

    @Override
    public final void job() throws Exception {
        this.setState(StructureJob.State.PENDING, StructureJob.State.RUNNING);
        try {
            this.doJob();
        }
        finally {
            this.setState(StructureJob.State.RUNNING, StructureJob.State.FINISHED);
        }
    }

    protected abstract void doJob() throws Exception;
}

