package com.almworks.jira.structure.api.item.generic;

import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * <p>{@code GenericItemManager} is responsible for performing operations with generic items.</p>
 *
 * <p>Unlike {@link GenericItemService} it doesn't operate with validation results, performs minimum checks
 * and throws {@link StructureException} if anything goes wrong.</p>
 *
 * @see GenericItemService
 * @see GenericItem
 */
@PublicApi
public interface GenericItemManager {
  @NotNull
  ItemIdentity createItem(@NotNull String itemType, @NotNull GenericItem genericItem) throws StructureException;

  @Nullable
  GenericItem getItem(@NotNull ItemIdentity itemId);

  void updateItem(@NotNull ItemIdentity itemId, @NotNull GenericItem genericItem) throws StructureException;

  void deleteItem(@NotNull ItemIdentity itemId) throws StructureException;

  @NotNull
  ItemIdentity getOwnedItem(@NotNull ItemIdentity itemId, long structureId, boolean copyIfSame) throws StructureException;

  boolean isVisible(@NotNull GenericItem item, @Nullable ApplicationUser user);
}