package com.almworks.jira.structure.api.attribute.loader.delegate;

import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.*;
import com.almworks.jira.structure.api.item.ItemIdentity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public class DelegatingItemAttributeLoader<T> extends DelegatingAttributeLoader<T, ItemAttributeLoader<T>> implements ItemAttributeLoader<T> {
  public DelegatingItemAttributeLoader(@NotNull ItemAttributeLoader<T> loader) {
    super(loader);
  }

  @Override
  public boolean isItemTypeSupported(@NotNull String itemType) {
    return delegate().isItemTypeSupported(itemType);
  }

  @Override
  @Nullable
  public AttributeValue<T> loadValue(@NotNull ItemIdentity itemId, @NotNull ItemAttributeContext context) {
    return delegate().loadValue(itemId, context);
  }

  @Override
  public void preload(@NotNull Collection<ItemIdentity> itemIds, @NotNull AttributeContext context) {
    delegate().preload(itemIds, context);
  }
}
