package com.almworks.jira.structure.api.attribute.loader.delegate;

import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.AggregateAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AggregateAttributeLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class DelegatingAggregateAttributeLoader<T> extends DelegatingRowAttributeLoader<T, AggregateAttributeLoader<T>> implements AggregateAttributeLoader<T> {
  public DelegatingAggregateAttributeLoader(@NotNull AggregateAttributeLoader<T> loader) {
    super(loader);
  }

  @Override
  @Nullable
  public AttributeValue<T> loadValue(@NotNull List<AttributeValue<T>> childrenValues, @NotNull AggregateAttributeContext context) {
    return delegate().loadValue(childrenValues, context);
  }
}
