/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.sync;

import com.atlassian.annotations.PublicApi;

@PublicApi
public enum SyncDirection {
    INBOUND,
    OUTBOUND;

    public static final String CODE_OUTBOUND = "OUT";
    public static final String CODE_INBOUND = "IN";

    public static String getCode(SyncDirection direction) {
        if (direction == null) {
            return "null";
        }
        switch (direction) {
            case INBOUND: {
                return CODE_INBOUND;
            }
            case OUTBOUND: {
                return CODE_OUTBOUND;
            }
        }
        throw new IllegalArgumentException(direction.toString());
    }

    public static SyncDirection fromCode(String code) {
        if (code == null || "null".equals(code)) {
            return null;
        }
        switch (code) {
            case "IN": {
                return INBOUND;
            }
            case "OUT": {
                return OUTBOUND;
            }
        }
        throw new IllegalArgumentException(code);
    }
}

