/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.row;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.StructureRow;
import com.atlassian.annotations.Internal;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class TransientRow
implements StructureRow {
    private final StructureRow myDelegate;
    private final long myCreatorId;
    private final long myOriginalId;

    public TransientRow(@NotNull StructureRow delegate, long creatorId, long originalId) {
        this.myDelegate = delegate;
        this.myCreatorId = creatorId;
        this.myOriginalId = originalId;
    }

    @Override
    public long getRowId() {
        return this.myDelegate.getRowId();
    }

    @Override
    @NotNull
    public ItemIdentity getItemId() {
        return this.myDelegate.getItemId();
    }

    @Override
    public long getSemantics() {
        return this.myDelegate.getSemantics();
    }

    @Override
    @Nullable
    public <I> I getItem(@NotNull Class<I> itemClass) {
        return this.myDelegate.getItem(itemClass);
    }

    public long getCreatorId() {
        return this.myCreatorId;
    }

    public long getOriginalId() {
        return this.myOriginalId;
    }

    public String toString() {
        return "TransientRow[" + this.getRowId() + ":" + this.getItemId() + ":" + this.getSemantics() + ":" + this.myCreatorId + ":" + this.myOriginalId + "]";
    }

    public static long getCreatorId(StructureRow row) {
        return row instanceof TransientRow ? ((TransientRow)row).getCreatorId() : 0L;
    }

    public static long getOriginalId(StructureRow row) {
        return row instanceof TransientRow ? ((TransientRow)row).getOriginalId() : 0L;
    }

    public static StructureRow getDelegate(StructureRow row) {
        while (row instanceof TransientRow) {
            row = ((TransientRow)row).myDelegate;
        }
        return row;
    }

    public static StructureRow replaceDelegate(StructureRow row, Function<StructureRow, StructureRow> replacer) {
        if (row instanceof TransientRow) {
            StructureRow replaced;
            TransientRow tr = (TransientRow)row;
            StructureRow delegate = TransientRow.getDelegate(row);
            return delegate == (replaced = replacer.apply(delegate)) || replaced == null ? row : new TransientRow(replaced, tr.getCreatorId(), tr.getOriginalId());
        }
        StructureRow replaced = replacer.apply(row);
        return replaced == null ? row : replaced;
    }
}

