/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.query;

import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.jira.util.MessageSet;
import java.util.List;

public class StructureQueryConstraints {
    public static MessageSet validateArgumentCount(List<String> arguments, int minArguments, int maxArguments, MessageSet messageSet) {
        assert (minArguments <= maxArguments);
        int nArgs = arguments.size();
        if (nArgs < minArguments) {
            messageSet.addErrorMessage(StructureUtil.getTextInCurrentUserLocale("s.jql.constraints.error.args.min", nArgs, minArguments));
        }
        if (nArgs > maxArguments) {
            messageSet.addErrorMessage(StructureUtil.getTextInCurrentUserLocale("s.jql.constraints.error.args.max", nArgs, maxArguments));
        }
        return messageSet;
    }

    private StructureQueryConstraints() {
    }
}

