/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.composition;

import com.almworks.integers.LongSet;
import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.AggregateAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AggregateAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeCachingStrategy;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeContextDependency;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.DerivedAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.DerivedAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.ItemAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.ItemAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.PropagateAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.PropagateAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.RowAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.ScanningAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.ScanningAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.SingleRowAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.SingleRowAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.TrailItemSet;
import com.almworks.jira.structure.api.attribute.loader.basic.AbstractAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.composition.AttributeLoaderAdapter;
import com.almworks.jira.structure.api.attribute.loader.composition.LoaderType;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.util.ConsiderateLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompositeAttributeLoader<T, L extends AttributeLoader<T>>
extends AbstractAttributeLoader<T> {
    private static final Logger logger = LoggerFactory.getLogger(CompositeAttributeLoader.class);
    private static final ConsiderateLogger considerateLogger = new ConsiderateLogger(logger);
    private static final Comparator<AttributeLoader> ASCENDING_BY_TYPES_WEIGHT = Comparator.comparingInt(attributeLoader -> LoaderType.getType(attributeLoader).getLoaderWeight());
    private final AttributeCachingStrategy myCachingStrategy;
    private final Set<AttributeSpec<?>> myAttributeDependencies;
    private final Set<AttributeContextDependency> myContextDependencies;
    private final TrailItemSet myGlobalTrail;
    final Collection<L> myLoaders;

    protected CompositeAttributeLoader(AttributeSpec<T> spec, @NotNull Collection<L> loaders) {
        super(spec);
        this.myLoaders = Collections.unmodifiableCollection(loaders);
        this.myCachingStrategy = CompositeAttributeLoader.getCompositeCachingStrategy(spec, this.myLoaders);
        this.myAttributeDependencies = CompositeAttributeLoader.getCompositeDependencies(this.myLoaders);
        this.myContextDependencies = CompositeAttributeLoader.getCompositeContextDependencies(this.myLoaders);
        this.myGlobalTrail = CompositeAttributeLoader.getCompositeGlobalTrail(this.myLoaders);
    }

    public static <T> AttributeLoader<T> create(AttributeSpec<T> spec, List<AttributeLoader<T>> loaders) {
        if (loaders == null || loaders.isEmpty()) {
            throw new IllegalArgumentException("empty or null loaders");
        }
        LoaderType loaderType = LoaderType.getType(Collections.max(loaders, ASCENDING_BY_TYPES_WEIGHT));
        switch (loaderType) {
            case ITEM: {
                return new ItemAL<T>(spec, CompositeAttributeLoader.adaptOrSkipNonTargetTypeLoaders(loaderType, loaders));
            }
            case DERIVED: {
                return new DerivedAL<T>(spec, CompositeAttributeLoader.adaptOrSkipNonTargetTypeLoaders(loaderType, loaders));
            }
            case SINGLE_ROW: {
                return new SingleRowAL<T>(spec, CompositeAttributeLoader.adaptOrSkipNonTargetTypeLoaders(loaderType, loaders));
            }
            case AGGREGATE: {
                return new AggregateAL<T>(spec, CompositeAttributeLoader.adaptOrSkipNonTargetTypeLoaders(loaderType, loaders));
            }
            case PROPAGATE: {
                return new PropagateAL<T>(spec, CompositeAttributeLoader.adaptOrSkipNonTargetTypeLoaders(loaderType, loaders));
            }
            case SCANNING: {
                return new ScanningAL<T>(spec, CompositeAttributeLoader.adaptOrSkipNonTargetTypeLoaders(loaderType, loaders));
            }
        }
        throw new IllegalArgumentException("unsupported AttributeLoader type");
    }

    private static <T> List<AttributeLoader> adaptOrSkipNonTargetTypeLoaders(LoaderType targetLoaderType, List<AttributeLoader<T>> loaders) {
        Class<? extends AttributeLoader> targetLoaderClass = targetLoaderType.getLoaderClass();
        return loaders.stream().map(AttributeLoaderAdapter.tryAdaptLoader(targetLoaderType)).filter(loader -> {
            if (targetLoaderClass.isInstance(loader)) {
                return true;
            }
            logger.warn("Loader {} excluded due to inconsistency with loader type: {}", loader.getClass(), (Object)targetLoaderType);
            return false;
        }).map(targetLoaderClass::cast).collect(Collectors.toList());
    }

    private static <T, L extends AttributeLoader<T>> AttributeValue<T> loadValue(@NotNull Collection<L> loaders, @NotNull Function<L, AttributeValue<T>> loadFunction) {
        return loaders.stream().map(loadFunction).filter(Objects::nonNull).findFirst().orElse(AttributeValue.undefined());
    }

    @Override
    @NotNull
    public AttributeCachingStrategy getCachingStrategy() {
        return this.myCachingStrategy;
    }

    @Override
    @NotNull
    public Set<AttributeSpec<?>> getAttributeDependencies() {
        return this.myAttributeDependencies;
    }

    @Override
    @NotNull
    public Set<AttributeContextDependency> getContextDependencies() {
        return this.myContextDependencies;
    }

    @Override
    @Nullable
    public TrailItemSet getGlobalTrail() {
        return this.myGlobalTrail;
    }

    final AttributeValue<T> loadCompositeValue(Function<L, AttributeValue<T>> loadFunction) {
        return CompositeAttributeLoader.loadValue(this.myLoaders, loadFunction);
    }

    public static <L extends AttributeLoader<?>> AttributeCachingStrategy getCompositeCachingStrategy(AttributeSpec<?> spec, Collection<L> loaders) {
        EnumSet<AttributeCachingStrategy> strategies = EnumSet.noneOf(AttributeCachingStrategy.class);
        for (AttributeLoader loader : loaders) {
            if (loader.getCachingStrategy() == null) continue;
            strategies.add(loader.getCachingStrategy());
        }
        if (strategies.contains((Object)AttributeCachingStrategy.MUST_NOT) && strategies.contains((Object)AttributeCachingStrategy.SHOULD)) {
            considerateLogger.warn(spec.toString(), "composite loader has MUST_NOT and SHOULD caching strategies in it simple loaders simultaneously");
        }
        if (strategies.contains((Object)AttributeCachingStrategy.MUST_NOT)) {
            return AttributeCachingStrategy.MUST_NOT;
        }
        if (strategies.contains((Object)AttributeCachingStrategy.SHOULD_NOT)) {
            return AttributeCachingStrategy.SHOULD_NOT;
        }
        if (strategies.contains((Object)AttributeCachingStrategy.SHOULD)) {
            return AttributeCachingStrategy.SHOULD;
        }
        return AttributeCachingStrategy.MAY;
    }

    public static <L extends AttributeLoader<?>> Set<AttributeSpec<?>> getCompositeDependencies(Collection<L> loaders) {
        return loaders.stream().map(AttributeLoader::getAttributeDependencies).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public static <L extends AttributeLoader<?>> Set<AttributeContextDependency> getCompositeContextDependencies(Collection<L> loaders) {
        return loaders.stream().map(AttributeLoader::getContextDependencies).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> EnumSet.noneOf(AttributeContextDependency.class)), Collections::unmodifiableSet));
    }

    public static <L extends AttributeLoader<?>> TrailItemSet getCompositeGlobalTrail(Collection<L> loaders) {
        return loaders.stream().map(AttributeLoader::getGlobalTrail).filter(Objects::nonNull).reduce(TrailItemSet::union).orElse(null);
    }

    public static List<Class<?>> getLoaderClasses(AttributeLoader<?> loader) {
        if (loader == null) {
            return Collections.emptyList();
        }
        LinkedHashSet set = new LinkedHashSet();
        CompositeAttributeLoader.traverseLoaderClasses(loader, set);
        return new ArrayList(set);
    }

    private static void traverseLoaderClasses(AttributeLoader<?> loader, Set<Class<?>> set) {
        if (!(loader instanceof CompositeAttributeLoader)) {
            set.add(loader.getClass());
        } else {
            Collection loaders = ((CompositeAttributeLoader)loader).myLoaders;
            for (AttributeLoader elementLoader : loaders) {
                if (elementLoader instanceof AttributeLoaderAdapter) {
                    Object adaptedLoader = ((AttributeLoaderAdapter)elementLoader).getAdaptedLoader();
                    CompositeAttributeLoader.traverseLoaderClasses(adaptedLoader, set);
                    continue;
                }
                CompositeAttributeLoader.traverseLoaderClasses(elementLoader, set);
            }
        }
    }

    private static class ItemAL<T>
    extends CompositeAttributeLoader<T, ItemAttributeLoader<T>>
    implements ItemAttributeLoader<T> {
        private final Map<String, Collection<ItemAttributeLoader<T>>> myLoadersByItemTypes = new ConcurrentHashMap<String, Collection<ItemAttributeLoader<T>>>();

        ItemAL(AttributeSpec<T> spec, @NotNull Collection<ItemAttributeLoader<T>> loaders) {
            super(spec, loaders);
        }

        @Override
        public boolean isItemTypeSupported(String itemType) {
            return this.getLoadersToWorkWithItemType(itemType).size() > 0;
        }

        @Override
        public void preload(@NotNull Collection<ItemIdentity> itemIds, @NotNull AttributeContext context) {
            for (ItemAttributeLoader loader : this.myLoaders) {
                Collection supportedItemIds = itemIds.stream().filter(id -> loader.isItemTypeSupported(id.getItemType())).collect(Collectors.toList());
                loader.preload(supportedItemIds, context);
            }
        }

        @Override
        @Nullable
        public AttributeValue<T> loadValue(ItemIdentity itemId, ItemAttributeContext context) {
            return CompositeAttributeLoader.loadValue(this.getLoadersToWorkWithItemType(itemId.getItemType()), loader -> loader.loadValue(itemId, context));
        }

        private Collection<ItemAttributeLoader<T>> getLoadersToWorkWithItemType(String itemType) {
            Collection<ItemAttributeLoader<T>> attributeLoadersForItemType = this.myLoadersByItemTypes.get(itemType);
            if (attributeLoadersForItemType != null) {
                return attributeLoadersForItemType;
            }
            return this.myLoadersByItemTypes.computeIfAbsent(itemType, itemTypeKey -> {
                LinkedList<ItemAttributeLoader> loadersForItemType = new LinkedList<ItemAttributeLoader>();
                for (ItemAttributeLoader loader : this.myLoaders) {
                    if (!loader.isItemTypeSupported((String)itemTypeKey)) continue;
                    loadersForItemType.add(loader);
                }
                return loadersForItemType.isEmpty() ? Collections.emptyList() : Collections.unmodifiableCollection(loadersForItemType);
            });
        }
    }

    private static class DerivedAL<T>
    extends CompositeAttributeLoader<T, DerivedAttributeLoader<T>>
    implements DerivedAttributeLoader<T> {
        DerivedAL(AttributeSpec<T> spec, @NotNull Collection<DerivedAttributeLoader<T>> loaders) {
            super(spec, loaders);
        }

        @Override
        public AttributeValue<T> loadValue(DerivedAttributeContext context) {
            return this.loadCompositeValue(loader -> loader.loadValue(context));
        }
    }

    private static class SingleRowAL<T>
    extends RowAL<T, SingleRowAttributeLoader<T>>
    implements SingleRowAttributeLoader<T> {
        SingleRowAL(AttributeSpec<T> spec, @NotNull Collection<SingleRowAttributeLoader<T>> loaders) {
            super(spec, loaders);
        }

        @Override
        public AttributeValue<T> loadValue(StructureRow row, SingleRowAttributeContext context) {
            return this.loadCompositeValue(loader -> loader.loadValue(row, context));
        }
    }

    private static class ScanningAL<T>
    extends RowAL<T, ScanningAttributeLoader<T>>
    implements ScanningAttributeLoader<T> {
        ScanningAL(AttributeSpec<T> spec, @NotNull Collection<ScanningAttributeLoader<T>> loaders) {
            super(spec, loaders);
        }

        @Override
        @Nullable
        public AttributeValue<T> loadValue(@NotNull AttributeValue<T> precedingValue, @NotNull ScanningAttributeContext context) {
            return this.loadCompositeValue(loader -> loader.loadValue(precedingValue, context));
        }
    }

    private static class AggregateAL<T>
    extends RowAL<T, AggregateAttributeLoader<T>>
    implements AggregateAttributeLoader<T> {
        AggregateAL(AttributeSpec<T> spec, @NotNull Collection<AggregateAttributeLoader<T>> loaders) {
            super(spec, loaders);
        }

        @Override
        public AttributeValue<T> loadValue(List<AttributeValue<T>> childrenValues, AggregateAttributeContext context) {
            return this.loadCompositeValue(loader -> loader.loadValue(childrenValues, context));
        }
    }

    private static class PropagateAL<T>
    extends RowAL<T, PropagateAttributeLoader<T>>
    implements PropagateAttributeLoader<T> {
        PropagateAL(AttributeSpec<T> spec, @NotNull Collection<PropagateAttributeLoader<T>> loaders) {
            super(spec, loaders);
        }

        @Override
        @Nullable
        public BiFunction<StructureRow, PropagateAttributeContext, AttributeValue<T>> loadChildren(@NotNull AttributeValue<T> parentValue, @NotNull PropagateAttributeContext.Parent context) {
            return this.myLoaders.stream().map(loader -> loader.loadChildren(parentValue, context)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        @Override
        public boolean isLoadingSuperRoot() {
            return this.myLoaders.stream().anyMatch(PropagateAttributeLoader::isLoadingSuperRoot);
        }
    }

    private static abstract class RowAL<T, L extends RowAttributeLoader<T>>
    extends CompositeAttributeLoader<T, L>
    implements RowAttributeLoader<T> {
        private final boolean myWholeForestDependent;

        RowAL(AttributeSpec<T> spec, @NotNull Collection<L> loaders) {
            super(spec, loaders);
            this.myWholeForestDependent = loaders.stream().anyMatch(RowAttributeLoader::isWholeForestDependent);
        }

        @Override
        public void preload(@NotNull LongSet rowIds, @NotNull ItemForest forest, @NotNull AttributeContext context) {
            for (RowAttributeLoader loader : this.myLoaders) {
                loader.preload(rowIds, forest, context);
            }
        }

        @Override
        public boolean isWholeForestDependent() {
            return this.myWholeForestDependent;
        }
    }
}

