/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.AttributeCachingStrategy;
import com.almworks.jira.structure.api.attribute.loader.AttributeContextDependency;
import com.almworks.jira.structure.api.attribute.loader.DerivedAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.DerivedAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.TrailItemSet;
import com.almworks.jira.structure.api.attribute.loader.basic.AbstractDerivedAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.builder.AttributeLoaderBuilder;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiDerivedAttributeLoaderBuilder<T, X, Y>
extends AttributeLoaderBuilder<T, BiDerivedAttributeLoaderBuilder<T, X, Y>> {
    private AttributeSpec<X> myXDependencySpec;
    private AttributeSpec<Y> myYDependencySpec;
    private BiFunction<X, Y, T> myValueFunction;
    private Function<X, ItemIdentity> myXTrailFunction;
    private Function<Y, ItemIdentity> myYTrailFunction;
    private boolean myYieldOnNull = true;

    public DerivedAttributeLoader<T> build() {
        return new BuiltBiDerivedLoader<T, X, Y>(BiDerivedAttributeLoaderBuilder.notNull(this.myAttributeSpec, "attributeSpec"), BiDerivedAttributeLoaderBuilder.notNull(this.myXDependencySpec, "xDependency"), BiDerivedAttributeLoaderBuilder.notNull(this.myYDependencySpec, "yDependency"), this.myYieldOnNull, BiDerivedAttributeLoaderBuilder.notNull(this.myValueFunction, "derivationFunction"), this.myXTrailFunction, this.myYTrailFunction, BiDerivedAttributeLoaderBuilder.nullableCollectionOfNonNulls(this.buildContextDependencies(), "contextDependencies"), this.myCachingStrategy, this.myGlobalTrail);
    }

    public BiDerivedAttributeLoaderBuilder<T, X, Y> xDependency(AttributeSpec<X> xDependencySpec) {
        this.myXDependencySpec = xDependencySpec;
        return this;
    }

    public BiDerivedAttributeLoaderBuilder<T, X, Y> yDependency(AttributeSpec<Y> yDependencySpec) {
        this.myYDependencySpec = yDependencySpec;
        return this;
    }

    public BiDerivedAttributeLoaderBuilder<T, X, Y> dependencies(AttributeSpec<X> xDependencySpec, AttributeSpec<Y> yDependencySpec) {
        this.myXDependencySpec = xDependencySpec;
        this.myYDependencySpec = yDependencySpec;
        return this;
    }

    public BiDerivedAttributeLoaderBuilder<T, X, Y> valueFunction(BiFunction<X, Y, T> derivationFunction) {
        this.myValueFunction = derivationFunction;
        return this;
    }

    public BiDerivedAttributeLoaderBuilder<T, X, Y> xTrail(Function<X, ItemIdentity> xTrailFunction) {
        this.myXTrailFunction = xTrailFunction;
        if (xTrailFunction != null) {
            this.contextDependency(AttributeContextDependency.TRAIL);
        }
        return this;
    }

    public BiDerivedAttributeLoaderBuilder<T, X, Y> yTrail(Function<Y, ItemIdentity> yTrailFunction) {
        this.myYTrailFunction = yTrailFunction;
        if (yTrailFunction != null) {
            this.contextDependency(AttributeContextDependency.TRAIL);
        }
        return this;
    }

    public BiDerivedAttributeLoaderBuilder<T, X, Y> yieldOnNull(boolean yieldOnNull) {
        this.myYieldOnNull = yieldOnNull;
        return this;
    }

    public static class BuiltBiDerivedLoader<T, X, Y>
    extends AbstractDerivedAttributeLoader<T> {
        private final AttributeSpec<? extends X> myXDependency;
        private final AttributeSpec<? extends Y> myYDependency;
        private final Set<AttributeSpec<?>> myDependencies;
        private final BiFunction<X, Y, T> myDerivationFunction;
        private final Function<X, ItemIdentity> myXTrailFunction;
        private final Function<Y, ItemIdentity> myYTrailFunction;
        private final Set<AttributeContextDependency> myContextDependencies;
        private final AttributeCachingStrategy myCachingStrategy;
        private final boolean myYield;
        private final TrailItemSet myGlobalTrail;

        public BuiltBiDerivedLoader(AttributeSpec<T> spec, AttributeSpec<? extends X> xDependency, AttributeSpec<? extends Y> yDependency, boolean yield, BiFunction<X, Y, T> derivationFunction, Function<X, ItemIdentity> xTrailFunction, Function<Y, ItemIdentity> yTrailFunction, Set<AttributeContextDependency> contextDependencies, AttributeCachingStrategy cachingStrategy, TrailItemSet globalTrail) {
            super(spec);
            this.myXDependency = xDependency;
            this.myYDependency = yDependency;
            this.myYield = yield;
            this.myDependencies = ImmutableSet.of(this.myXDependency, this.myYDependency);
            this.myDerivationFunction = derivationFunction;
            this.myXTrailFunction = xTrailFunction;
            this.myYTrailFunction = yTrailFunction;
            this.myContextDependencies = contextDependencies;
            this.myCachingStrategy = cachingStrategy;
            this.myGlobalTrail = globalTrail;
        }

        @Override
        @Nullable
        public Set<AttributeSpec<?>> getAttributeDependencies() {
            return this.myDependencies;
        }

        @Override
        @Nullable
        public AttributeValue<T> loadValue(@NotNull DerivedAttributeContext context) {
            T value;
            AttributeValue<X> xValue = context.getDependencyAttributeValue(this.myXDependency);
            AttributeValue<Y> yValue = context.getDependencyAttributeValue(this.myYDependency);
            X x = xValue.getValue();
            Y y = yValue.getValue();
            Object result = x == null || y == null ? (this.myYield ? null : AttributeValue.undefined()) : ((value = this.getValue(x, y, context)) == null && this.myYield ? null : AttributeValue.ofNullable(value));
            return result;
        }

        @Nullable
        protected T getValue(@NotNull X x, @NotNull Y y, DerivedAttributeContext context) {
            this.addTrail(x, this.myXTrailFunction, context);
            this.addTrail(y, this.myYTrailFunction, context);
            return this.myDerivationFunction.apply(x, y);
        }

        private <V> void addTrail(@NotNull V value, Function<V, ItemIdentity> trailFunction, DerivedAttributeContext context) {
            ItemIdentity trail;
            if (trailFunction != null && (trail = trailFunction.apply(value)) != null) {
                context.addTrail(trail);
            }
        }

        @Override
        @Nullable
        public Set<AttributeContextDependency> getContextDependencies() {
            return this.myContextDependencies == null ? super.getContextDependencies() : this.myContextDependencies;
        }

        @Override
        @Nullable
        public AttributeCachingStrategy getCachingStrategy() {
            return this.myCachingStrategy == null ? super.getCachingStrategy() : this.myCachingStrategy;
        }

        @Override
        @Nullable
        public TrailItemSet getGlobalTrail() {
            return this.myGlobalTrail == null ? super.getGlobalTrail() : this.myGlobalTrail;
        }
    }
}

